/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.HybsURLTagFragmentGenerator;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ChartCreateTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2007/06/29)";
    private static final long serialVersionUID = 4000L;
    private static final String FILE_URL = HybsSystem.sys("CHART_TEMP_DIR");
    private List<ChartDataset> chartDataset = null;
    private static final String CHART_CACHE_KEY = "h_chartKey";
    private String title = null;
    private int width = 200;
    private int height = 200;
    private String domainLabel = null;
    private boolean showLegend = true;
    private String rectangleEdge = "BOTTOM";
    private String plotOrientation = "VERTICAL";
    private String chartBackColor = null;
    private String plotBackColor = null;
    private int rotationLabel = 3;
    private String domainMarker = null;
    private boolean useDomainLabel = true;
    private boolean useMarkerLabel = true;
    private boolean useCache = false;
    private int seriesPikup = -1;
    private String masterKey = null;
    private transient Map<String, ChartCache> map = null;
    private transient ChartCache cache = null;
    private String imgTag = null;
    private String imageMapUrl = null;
    private String imageMapTarget = null;
    private long dyStart = 0L;
    private String categoryMargin = null;
    private String lowerMargin = null;
    private String upperMargin = null;
    private boolean useDomainLine = false;
    private String domainLineColor = null;
    private boolean useRangeLine = true;
    private String rangeLineColor = null;
    private int categorySkip = 1;
    private int categoryCutNo = -1;
    private String categoryAnchor = null;
    private int rangeSkip = 1;
    private boolean useToolTip = false;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        if (this.useCache) {
            this.map = (Map)this.getSessionAttribute(CHART_CACHE_KEY);
            if (this.map != null) {
                this.cache = this.map.get(this.masterKey);
                if (this.cache != null && this.cache.isAvailable()) {
                    String string = String.valueOf(this.seriesPikup);
                    this.imgTag = this.cache.getFileAddress(string);
                    return 0;
                }
            }
        }
        return 2;
    }

    @Override
    public int doEndTag() {
        long l = System.currentTimeMillis();
        this.jspPrint("<div id=\"queryTime\" value=\"" + (l - this.dyStart) + "\"></div>");
        if (this.isDebug()) {
            this.debugPrint();
        }
        if (this.imgTag != null) {
            this.jspPrint(this.imgTag);
        } else {
            String string;
            Object object;
            JFreeChart jFreeChart;
            if (this.cache != null) {
                jFreeChart = this.cache.getJFreeChart();
                jFreeChart = ChartCreate.modifying(jFreeChart, this.seriesPikup);
            } else {
                object = this.create();
                jFreeChart = ((ChartCreate)object).getChart();
            }
            object = this.getTempFile(FILE_URL);
            try {
                string = ((File)object).getName();
                String string2 = this.getContextPath() + "/" + FILE_URL + string;
                String string3 = string.substring(0, string.length() - 4);
                StandardToolTipTagFragmentGenerator standardToolTipTagFragmentGenerator = null;
                HybsURLTagFragmentGenerator hybsURLTagFragmentGenerator = null;
                if (this.useToolTip) {
                    standardToolTipTagFragmentGenerator = new StandardToolTipTagFragmentGenerator();
                }
                if (this.imageMapUrl != null) {
                    hybsURLTagFragmentGenerator = new HybsURLTagFragmentGenerator(this.imageMapTarget);
                }
                if (this.imageMapUrl != null || this.useToolTip) {
                    ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                    ChartUtilities.saveChartAsPNG((File)object, (JFreeChart)jFreeChart, (int)this.width, (int)this.height, (ChartRenderingInfo)chartRenderingInfo);
                    this.imgTag = ImageMapUtilities.getImageMap((String)string3, (ChartRenderingInfo)chartRenderingInfo, (ToolTipTagFragmentGenerator)standardToolTipTagFragmentGenerator, (URLTagFragmentGenerator)hybsURLTagFragmentGenerator) + this.makeTag2(string2, string3);
                } else {
                    ChartUtilities.saveChartAsPNG((File)object, (JFreeChart)jFreeChart, (int)this.width, (int)this.height);
                    this.imgTag = this.makeTag2(string2, null);
                }
            }
            catch (IOException iOException) {
                String string4 = "\u30d5\u30a1\u30a4\u30eb I/O \u304c\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + object + HybsSystem.CR + iOException.getMessage();
                throw new HybsSystemException(string4, iOException);
            }
            this.jspPrint(this.imgTag);
            if (this.useCache) {
                if (this.cache == null) {
                    this.cache = new ChartCache(this.masterKey);
                    this.cache.setJFreeChart(jFreeChart);
                }
                string = String.valueOf(this.seriesPikup);
                this.cache.putFileAddress(string, this.imgTag);
                if (this.map == null) {
                    this.map = new HashMap<String, ChartCache>();
                }
                this.map.put(this.masterKey, this.cache);
                this.setSessionAttribute(CHART_CACHE_KEY, this.map);
            } else {
                this.removeSessionAttribute(CHART_CACHE_KEY);
            }
        }
        long l2 = System.currentTimeMillis();
        this.jspPrint("<div id=\"viewTime\" value=\"" + (l2 - this.dyStart) + "\"></div>");
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.chartDataset = null;
        this.title = null;
        this.width = 200;
        this.height = 200;
        this.domainLabel = null;
        this.showLegend = true;
        this.rectangleEdge = "BOTTOM";
        this.plotOrientation = "VERTICAL";
        this.chartBackColor = null;
        this.plotBackColor = null;
        this.rotationLabel = 3;
        this.domainMarker = null;
        this.useDomainLabel = true;
        this.useMarkerLabel = true;
        this.useCache = false;
        this.seriesPikup = -1;
        this.masterKey = null;
        this.map = null;
        this.cache = null;
        this.imgTag = null;
        this.imageMapUrl = null;
        this.imageMapTarget = null;
        this.categoryMargin = null;
        this.lowerMargin = null;
        this.upperMargin = null;
        this.useDomainLine = false;
        this.domainLineColor = null;
        this.useRangeLine = true;
        this.rangeLineColor = null;
        this.categorySkip = 1;
        this.categoryCutNo = -1;
        this.categoryAnchor = null;
        this.rangeSkip = 1;
    }

    private String makeTag2(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<img");
        if (string2 != null) {
            stringBuilder.append(" usemap=\"#").append(string2).append("\"");
        }
        stringBuilder.append(" width=\"").append(this.width).append("px\"");
        stringBuilder.append(" height=\"").append(this.height).append("px\"");
        stringBuilder.append(" src=\"").append(string).append("\" /> ");
        return stringBuilder.toString();
    }

    private ChartCreate create() {
        ChartCreate chartCreate = new ChartCreate();
        chartCreate.setTitle(this.title);
        chartCreate.setDomainLabel(this.domainLabel);
        chartCreate.setShowLegend(this.showLegend);
        chartCreate.setRectangleEdge(this.rectangleEdge);
        chartCreate.setPlotOrientation(this.plotOrientation);
        chartCreate.setChartBackColor(this.chartBackColor);
        chartCreate.setPlotBackColor(this.plotBackColor);
        chartCreate.setRotationLabel(this.rotationLabel);
        chartCreate.setDomainMarker(this.domainMarker);
        chartCreate.setUseDomainLabel(this.useDomainLabel);
        chartCreate.setUseMarkerLabel(this.useMarkerLabel);
        chartCreate.setSeriesPikup(this.seriesPikup);
        chartCreate.setImageMapUrl(this.imageMapUrl);
        chartCreate.setCategoryMargin(this.categoryMargin);
        chartCreate.setLowerMargin(this.lowerMargin);
        chartCreate.setUpperMargin(this.upperMargin);
        chartCreate.setUseDomainLine(this.useDomainLine);
        chartCreate.setDomainLineColor(this.domainLineColor);
        chartCreate.setUseRangeLine(this.useRangeLine);
        chartCreate.setRangeLineColor(this.rangeLineColor);
        chartCreate.setCategorySkip(this.categorySkip);
        chartCreate.setCategoryCutNo(this.categoryCutNo);
        chartCreate.setCategoryAnchor(this.categoryAnchor);
        chartCreate.setRangeSkip(this.rangeSkip);
        chartCreate.setUseToolTip(this.useToolTip);
        if (this.isDebug()) {
            chartCreate.setDebug(true);
        }
        chartCreate.setDatasetList(this.chartDataset);
        return chartCreate;
    }

    private File getTempFile(String string) {
        File file;
        String string2 = HybsSystem.url2dir(string);
        File file2 = new File(string2);
        if (!file2.exists() && !file2.mkdirs()) {
            String string3 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string2 + "]";
            throw new HybsSystemException(string3);
        }
        try {
            file = File.createTempFile("JFree", ".png", file2);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "Url:" + string;
            throw new HybsSystemException(string4, iOException);
        }
        return file;
    }

    public void setTitle(String string) {
        this.title = StringUtil.nval((String)this.getRequestParameter(string), (String)this.title);
    }

    public void setWidth(String string) {
        this.width = string != null && string.length() >= 3 && string.endsWith("px") ? Integer.valueOf(string.substring(0, string.length() - 2)) : StringUtil.nval((String)this.getRequestParameter(string), (int)this.width);
    }

    public void setHeight(String string) {
        this.height = string != null && string.length() >= 3 && string.endsWith("px") ? Integer.valueOf(string.substring(0, string.length() - 2)) : StringUtil.nval((String)this.getRequestParameter(string), (int)this.height);
    }

    public void setDomainLabel(String string) {
        this.domainLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainLabel);
    }

    public void setShowLegend(String string) {
        this.showLegend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.showLegend);
    }

    public void setRectangleEdge(String string) {
        this.rectangleEdge = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rectangleEdge);
    }

    public void setPlotOrientation(String string) {
        this.plotOrientation = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plotOrientation);
    }

    public void setChartBackColor(String string) {
        this.chartBackColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.chartBackColor);
    }

    public void setPlotBackColor(String string) {
        this.plotBackColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plotBackColor);
    }

    public void setRotationLabel(String string) {
        this.rotationLabel = StringUtil.nval((String)this.getRequestParameter(string), (int)this.rotationLabel);
    }

    public void setDomainMarker(String string) {
        this.domainMarker = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainMarker);
    }

    public void setUseDomainLabel(String string) {
        this.useDomainLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDomainLabel);
    }

    public void setUseMarkerLabel(String string) {
        this.useMarkerLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMarkerLabel);
    }

    public void setUseCache(String string) {
        this.useCache = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useCache);
    }

    public void setSeriesPikup(String string) {
        this.seriesPikup = StringUtil.nval((String)this.getRequestParameter(string), (int)this.seriesPikup);
    }

    public void setMasterKey(String string) {
        this.masterKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.masterKey);
    }

    public void setImageMapUrl(String string) {
        this.imageMapUrl = StringUtil.nval((String)this.getRequestParameter(string), (String)this.imageMapUrl);
    }

    public void setImageMapTarget(String string) {
        this.imageMapTarget = StringUtil.nval((String)this.getRequestParameter(string), (String)this.imageMapTarget);
    }

    public void setCategoryMargin(String string) {
        this.categoryMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.categoryMargin);
    }

    public void setLowerMargin(String string) {
        this.lowerMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.lowerMargin);
    }

    public void setUpperMargin(String string) {
        this.upperMargin = StringUtil.nval((String)this.getRequestParameter(string), (String)this.upperMargin);
    }

    public void setUseDomainLine(String string) {
        this.useDomainLine = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDomainLine);
    }

    public void setDomainLineColor(String string) {
        this.domainLineColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domainLineColor);
    }

    public void setCategorySkip(String string) {
        this.categorySkip = StringUtil.nval((String)this.getRequestParameter(string), (int)this.categorySkip);
    }

    public void setCategoryCutNo(String string) {
        this.categoryCutNo = StringUtil.nval((String)this.getRequestParameter(string), (int)this.categoryCutNo);
    }

    public void setCategoryAnchor(String string) {
        this.categoryAnchor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.categoryAnchor);
        if (!(this.categoryAnchor == null || this.categoryAnchor.length() <= 0 || "START".equals(this.categoryAnchor) || "MIDDLE".equals(this.categoryAnchor) || "END".equals(this.categoryAnchor))) {
            String string2 = "\u6307\u5b9a\u306eAnchor\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + HybsSystem.CR + "START,MIDDLE,END \u306e\u4e2d\u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setUseRangeLine(String string) {
        this.useRangeLine = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRangeLine);
    }

    public void setRangeLineColor(String string) {
        this.rangeLineColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rangeLineColor);
    }

    public void setRangeSkip(String string) {
        this.rangeSkip = StringUtil.nval((String)this.getRequestParameter(string), (int)this.rangeSkip);
    }

    public void setUseToolTip(String string) {
        this.useToolTip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useToolTip);
    }

    protected void addChartDataset(ChartDataset chartDataset) {
        if (this.chartDataset == null) {
            this.chartDataset = new ArrayList<ChartDataset>();
        }
        this.chartDataset.add(chartDataset);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[").append(((Object)((Object)this)).getClass().getName()).append("]").append(HybsSystem.CR);
        stringBuilder.append("title           [").append(this.title).append("]").append(HybsSystem.CR);
        stringBuilder.append("width           [").append(this.width).append("]").append(HybsSystem.CR);
        stringBuilder.append("height          [").append(this.height).append("]").append(HybsSystem.CR);
        stringBuilder.append("domainLabel     [").append(this.domainLabel).append("]").append(HybsSystem.CR);
        stringBuilder.append("showLegend      [").append(this.showLegend).append("]").append(HybsSystem.CR);
        stringBuilder.append("rectangleEdge   [").append(this.rectangleEdge).append("]").append(HybsSystem.CR);
        stringBuilder.append("plotOrientation [").append(this.plotOrientation).append("]").append(HybsSystem.CR);
        stringBuilder.append("chartBackColor  [").append(this.chartBackColor).append("]").append(HybsSystem.CR);
        stringBuilder.append("plotBackColor   [").append(this.plotBackColor).append("]").append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    private static final class ChartCache {
        private static final int CACHE_TIME = HybsSystem.sysInt("CHART_CACHE_TIME");
        private static final long MAX_CACHE_TIME = (long)CACHE_TIME * 1000L;
        private final Map<String, String> fileAdrs = new HashMap<String, String>();
        private final String mkey;
        private long createLimitTime = 0L;
        private JFreeChart chart = null;

        public ChartCache(String string) {
            this.mkey = string;
        }

        public void setJFreeChart(JFreeChart jFreeChart) {
            this.chart = jFreeChart;
            this.fileAdrs.clear();
            this.createLimitTime = System.currentTimeMillis() + MAX_CACHE_TIME;
        }

        public JFreeChart getJFreeChart() {
            return this.chart;
        }

        public void putFileAddress(String string, String string2) {
            this.fileAdrs.put(string, string2);
        }

        public String getFileAddress(String string) {
            return this.fileAdrs.get(string);
        }

        public boolean isAvailable() {
            return System.currentTimeMillis() < this.createLimitTime;
        }

        public boolean equals(Object object) {
            if (object instanceof ChartCache) {
                return this.mkey.equals(((ChartCache)object).mkey);
            }
            return false;
        }

        public int hashCode() {
            return this.mkey.hashCode();
        }
    }
}

