/**************************************************************************/
/* GE16 ( ユーザーパラメータ定義 )                                        */
/*                                                                        */
/* Created : 2009/08/21 23:39:03                                          */
/**************************************************************************/
CREATE TABLE GE16 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , USERID    VARCHAR2(10)                 NOT NULL      /* 20  ユーザーID     */
 , PARAM_ID  VARCHAR2(50)                 NOT NULL      /* 30  パラメータID   */
 , PARAM     VARCHAR2(500)                              /* 40  設定値         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 50  ユニークキー   */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  状態フラグ     */
 , DYSET     VARCHAR2(14)                               /* 70  登録日時       */
 , DYUPD     VARCHAR2(14)                               /* 80  更新日時       */
 , USRSET    VARCHAR2(10)                               /* 90  作成社員       */
 , USRUPD    VARCHAR2(10)                               /* 100 更新者         */
 , PRGUPD    VARCHAR2(10)                               /* 110 更新PRG        */
 , FGCRYPT   VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 120 要再起動フラグ */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE16S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE16T01 
BEFORE INSERT ON GE16
FOR EACH ROW 
BEGIN 
SELECT GE16S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

