/**************************************************************************/
/* GE31 ( 定型文マスタ )                                                  */
/*                                                                        */
/* Created : 2009/08/21 23:39:03                                          */
/**************************************************************************/
CREATE TABLE GE31 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , PTN_ID    VARCHAR2(20)                  NOT NULL      /* 20  定型文ID     */
 , FROM_ID   VARCHAR2(50)                                /* 30  送信者ID     */
 , TO_ID     VARCHAR2(4000)                              /* 40  宛先（TO）   */
 , CC_ID     VARCHAR2(4000)                              /* 50  宛先（CC）   */
 , BCC_ID    VARCHAR2(4000)                              /* 60  宛先（BCC）  */
 , TITLE     VARCHAR2(300)                 NOT NULL      /* 70  タイトル     */
 , CONTENT   VARCHAR2(4000)                              /* 80  内容         */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 90  ユニークキー */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 状態フラグ   */
 , DYSET     VARCHAR2(14)                                /* 110 登録日時     */
 , DYUPD     VARCHAR2(14)                                /* 120 更新日時     */
 , USRSET    VARCHAR2(10)                                /* 130 作成社員     */
 , USRUPD    VARCHAR2(10)                                /* 140 更新者       */
 , PRGUPD    VARCHAR2(10)                                /* 150 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE31S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE31T01 
BEFORE INSERT ON GE31
FOR EACH ROW 
BEGIN 
SELECT GE31S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

