/**************************************************************************/
/* GE38 ( ファイル種別マスタ )                                            */
/*                                                                        */
/* Created : 2009/08/21 23:39:03                                          */
/**************************************************************************/
CREATE TABLE GE38 (
   SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , SYKEY       VARCHAR2(10)                  NOT NULL      /* 20  種別キー     */
 , SYFILE      VARCHAR2(100)                               /* 30  ファイル種別 */
 , SYNAME      VARCHAR2(200)                               /* 40  種別名称     */
 , DESCRIPTION VARCHAR2(4000)                              /* 50  概要説明     */
 , HINAGATA    VARCHAR2(300)                               /* 60  雛形ファイル */
 , SAVE_FOLDER VARCHAR2(300)                               /* 70  保管フォルダ */
 , FILE_URL    VARCHAR2(300)                               /* 80  ファイルURL  */
 , ICON_URL    VARCHAR2(300)                               /* 90  アイコンURL  */
 , ROLES       VARCHAR2(500)                               /* 100 ロールズ     */
 , SU_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 110 閲覧制限数   */
 , DY_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 120 閲覧期日     */
 , SIZE_LMT    NUMBER(9)         DEFAULT 0   NOT NULL      /* 130 サイズ制限   */
 , SUFFIX_LMT  VARCHAR2(200)                               /* 140 拡張子制限   */
 , FGANGO      VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 150 暗号化FG     */
 , FGZIP       VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 160 圧縮FG       */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 170 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 180 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 190 登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 200 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 210 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 220 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 230 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE38S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE38T01 
BEFORE INSERT ON GE38
FOR EACH ROW 
BEGIN 
SELECT GE38S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

