/**************************************************************************/
/* GF44 ( サンプル社員定義 )                                              */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF44 (
   USERID VARCHAR2(10)                 NOT NULL      /* 10  ユーザーID   */
 , NAME   VARCHAR2(200)                              /* 20  名称         */
 , UNIQ   NUMBER(9)        DEFAULT 0   NOT NULL      /* 30  ユニークキー */
 , FGJ    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 40  状態フラグ   */
 , DYSET  VARCHAR2(14)                               /* 50  登録日時     */
 , PGSET  VARCHAR2(10)                               /* 60  作成PG       */
 , PGPSET VARCHAR2(10)                               /* 70  作成親PG     */
 , USRSET VARCHAR2(10)                               /* 80  作成社員     */
 , DYUPD  VARCHAR2(14)                               /* 90  更新日時     */
 , PGUPD  VARCHAR2(10)                               /* 100 更新PG       */
 , PGPUPD VARCHAR2(10)                               /* 110 更新親PG     */
 , USRUPD VARCHAR2(10)                               /* 120 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF44S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF44T01 
BEFORE INSERT ON GF44
FOR EACH ROW 
BEGIN 
SELECT GF44S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

