/**************************************************************************/
/* GF62 ( プロジェクトマスタ定義 )                                        */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF62 (
   PRJCODE     VARCHAR2(30)                                /* 10  PRJコード    */
 , NAME        VARCHAR2(200)                               /* 20  名称         */
 , COMPANY     VARCHAR2(200)                               /* 30  会社名       */
 , VIEW_DATE   VARCHAR2(8)                                 /* 40  表示開始日   */
 , VIEW_ZOOM   VARCHAR2(2)       DEFAULT '1'               /* 50  表示期間     */
 , VERSION     VARCHAR2(10)                                /* 60  バージョン   */
 , DESCRIPTION VARCHAR2(4000)                              /* 70  概要説明     */
 , CDJ         VARCHAR2(1)                                 /* 80  状況コード   */
 , YOSAN       NUMBER(9,2)                                 /* 90  予算         */
 , JISSEKI     NUMBER(9)                                   /* 100 実績         */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 110 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 120 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 130 登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 140 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 150 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 160 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 170 更新PRG      */
 , COLOR       VARCHAR2(7)                                 /* 180 カラー       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF62S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF62T01 
BEFORE INSERT ON GF62
FOR EACH ROW 
BEGIN 
SELECT GF62S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

