/**************************************************************************/
/* GF68 ( リソース計画ワーク )                                            */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF68 (
   RESOURCE_ID NUMBER(9)                                  /* 10  リソースID   */
 , SEQ         NUMBER(5)        DEFAULT 0   NOT NULL      /* 20  順           */
 , DYSTART     VARCHAR2(14)                               /* 30  開始日       */
 , DYDELAY     NUMBER(4,1)                                /* 40  開始遅延     */
 , DURATION    NUMBER(4,1)                                /* 50  期間         */
 , PRJCODE     VARCHAR2(30)                               /* 60  PRJコード    */
 , TASK_ID     NUMBER(5)                                  /* 70  タスクID     */
 , COMPLETE    NUMBER(3)                                  /* 80  進捗率       */
 , FGTASK      VARCHAR2(1)                                /* 90  FGTASK       */
 , VAL1        VARCHAR2(100)                              /* 100 VAL1         */
 , VAL2        VARCHAR2(100)                              /* 110 VAL2         */
 , VAL3        VARCHAR2(100)                              /* 120 VAL3         */
 , VAL4        VARCHAR2(100)                              /* 130 VAL4         */
 , VAL5        VARCHAR2(100)                              /* 140 VAL5         */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 150 ユニークキー */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 160 状態フラグ   */
 , DYSET       VARCHAR2(14)                               /* 170 登録日時     */
 , DYUPD       VARCHAR2(14)                               /* 180 更新日時     */
 , USRSET      VARCHAR2(10)                               /* 190 作成社員     */
 , USRUPD      VARCHAR2(10)                               /* 200 更新者       */
 , PRGUPD      VARCHAR2(10)                               /* 210 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF68S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF68T01 
BEFORE INSERT ON GF68
FOR EACH ROW 
BEGIN 
SELECT GF68S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

