/**************************************************************************/
/* GF70 ( JSPチェック結果テーブル )                                       */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF70 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS   VARCHAR2(256)                              /* 20  アドレス     */
 , FILENAME  VARCHAR2(30)                               /* 30  ファイル名   */
 , FILEPATH  VARCHAR2(256)                              /* 40  ファイルパス */
 , MODIFIED  VARCHAR2(14)                               /* 50  最終更新日   */
 , TAGNAME   VARCHAR2(30)                               /* 60  タグ名称     */
 , MSGCD     VARCHAR2(20)                               /* 70  メッセージID */
 , MSGTXT    VARCHAR2(500)                              /* 80  内容         */
 , TEXT      CLOB                                       /* 90  テキスト     */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 100 除外フラグ   */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 110 ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 120 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 130 登録日時     */
 , DYUPD     VARCHAR2(14)                               /* 140 更新日時     */
 , USRSET    VARCHAR2(10)                               /* 150 作成社員     */
 , USRUPD    VARCHAR2(10)                               /* 160 更新者       */
 , PRGUPD    VARCHAR2(10)                               /* 170 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF70S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF70T01 
BEFORE INSERT ON GF70
FOR EACH ROW 
BEGIN 
SELECT GF70S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

