/**************************************************************************/
/* GF74 ( QUERY状態テーブル )                                             */
/*                                                                        */
/* Created : 2009/08/21 23:39:04                                          */
/**************************************************************************/
CREATE TABLE GF74 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , ADDRESS   VARCHAR2(256)                              /* 20  アドレス       */
 , FILENAME  VARCHAR2(30)                               /* 30  ファイル名     */
 , FILEPATH  VARCHAR2(256)                              /* 40  ファイルパス   */
 , MODIFIED  VARCHAR2(14)                               /* 50  最終更新日     */
 , TAGNAME   VARCHAR2(30)                               /* 60  タグ名称       */
 , NAMES     VARCHAR2(500)                              /* 70  カラム一覧     */
 , TABLEID   VARCHAR2(50)                               /* 80  テーブルID     */
 , DBID      VARCHAR2(10)                               /* 90  データベースID */
 , QUERYTYPE VARCHAR2(20)                               /* 100 クエリータイプ */
 , SCOPE     VARCHAR2(20)                               /* 110 スコープ       */
 , QUERY     CLOB                                       /* 120 検索           */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 130 除外フラグ     */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 140 ユニークキー   */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 150 状態フラグ     */
 , DYSET     VARCHAR2(14)                               /* 160 登録日時       */
 , DYUPD     VARCHAR2(14)                               /* 170 更新日時       */
 , USRSET    VARCHAR2(10)                               /* 180 作成社員       */
 , USRUPD    VARCHAR2(10)                               /* 190 更新者         */
 , PRGUPD    VARCHAR2(10)                               /* 200 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF74S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF74T01 
BEFORE INSERT ON GF74
FOR EACH ROW 
BEGIN 
SELECT GF74S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

