﻿<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<!-- 画面遷移なしモード及びAjaxツリービューを有効にします -->
<og:head headType="result" useAjaxTreeTable="true" noTransition="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6170"
	title	= "Ajaxツリーメニュー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- クエリを発行します。ここでは、第一レベル(初期表示分)のみを検索します。-->
<!-- 初期全展開を行う場合は、startWith ConnectBy で子データも取得します。 -->
<og:query command="{@command}" debug="false" maxRowCount="{@maxRowCount}">
	<og:equals val1="{@EXPAND_ALL}" val2="true" notEquals="true">
		<jsp:text>
			select	'1' LVL
				,	A.MGR,A.JOB,A.EMPNO,A.ENAME
				,	A.SAL,A.COMM,A.HIREDATE,A.DEPTNO,B.DNAME,B.LOC
			from EMP A inner join DEPT B
			on	A.DEPTNO = B.DEPTNO
		</jsp:text>
		<og:where>
			<og:and value = "A.MGR  =  TO_NUMBER('{@MGR}') " />
		</og:where>
		<jsp:text>
			ORDER BY A.MGR
		</jsp:text>
	</og:equals>

	<og:equals val1="{@EXPAND_ALL}" val2="true">
		<jsp:text>
			select	LEVEL LVL
				,	A.MGR,A.JOB,A.EMPNO,A.ENAME
				,	A.SAL,A.COMM,A.HIREDATE,A.DEPTNO,B.DNAME,B.LOC
			from EMP A inner join DEPT B
			on	A.DEPTNO = B.DEPTNO
		</jsp:text>
		<og:where startKey="START WITH">
			<og:and value = "A.MGR  =  TO_NUMBER('{@MGR}') " />
		</og:where>
		<jsp:text>
			CONNECT BY PRIOR EMPNO = MGR
		</jsp:text>
	</og:equals>
</og:query>

<og:columnEditor column="DEPTNO" must="true" editor="DBMENU" addNoValue="false" >
	<jsp:text>select DEPTNO,DEPTNO from DEPT</jsp:text>
</og:columnEditor>
<og:columnEditor columns="MGR,EMPNO" must="true" />

<og:viewLink command="{@command}">
	<og:link column="MGR" gamenId="GF6160" href="index.jsp" target="CONTENTS"
		keys="command,MGR"
		vals="NEW,[MGR]" />
</og:viewLink>

<!-- 画面遷移なしモードで登録を行うため、formのidを"noTransition"とします。-->
<!-- idが指定されていない場合は、1番目のformに対して動的入力モードが適用されます。 -->
<form method="POST" action="forward.jsp" target="RESULT" id="noTransition">

<!-- 画面遷移なしモードでは、登録ボタンも合わせて表示します -->
<og:writeCheck>
	<fieldset style="display:inline; padding: 5px">
		<legend><strong><og:message lbl="ROW_OPERATION" /></strong></legend>
		<og:submit value="update" command="COPY"  lbl="INSERT_CHILD" accesskey="I"
			keys="LVLDOWN,columnWritable" vals='true,"MGR,JOB,EMPNO,ENAME,SAL,COMM,HIREDATE,DEPTNO"' />	<!--追加(I)-->
		<og:submit value="update" command="COPY"  lbl="COPY_EQLVL"   accesskey="C"
			keys="columnWritable" vals='"MGR,JOB,EMPNO,ENAME,SAL,COMM,DEPTNO,HIREDATE"' />				<!--複写(C)-->
		<og:submit value="update" command="MODIFY" lbl="MODIFY"  accesskey="M"
			keys="columnWritable" vals='"JOB,ENAME,SAL,COMM,DEPTNO,HIREDATE"' />						<!--変更(M)-->
		<og:submit value="update" command="DELETE" lbl="DELETE"  accesskey="D" />						<!--削除(D)-->
		<og:submit value="undo" lbl="UNDO" accesskey="U" onClick="return confirm('{@LBL.MSG0048}');"/>	<!--取消(R)-->
	</fieldset>

	<fieldset style="display:inline; padding: 5px; margin-left: 10px;">
		<legend><strong><og:message lbl="DATA_REGISTRATION" /></strong></legend>
		<og:submit value="entry"  lbl="ENTRY"  accesskey="E" />										<!--登録(E)-->
	</fieldset>
</og:writeCheck>

<!-- Ajaxツリー形式のビューを表示します。 -->
<!-- 子データを検索するためのJSPは、childSearchJspで指定します。-->
<!-- 遷移する際の引数には、commandとLVLが自動的に付加されます。 -->
<!-- LVLのカラム部分には、検索時に取得した階層と、子データ展開用の画像イメージが表示されます。 -->
<!-- 階層を視覚的に表示する場合は、LVLにレンデラーを適用して表示方法を制御して下さい。 -->
<og:view
	viewFormType	= "HTMLAjaxTreeTable"
	command			= "{@command}"
	useHilightRow	= "false"
	useParam		= "true">
	<og:ajaxTreeParam
		childSearchKeys	= "EMPNO"
		childSearchJsp	= "getChildRow.jsp"
		levelClm		= "LVL"
		imgCollapsed	= "collapsed.gif"
		imgExpanded		= "expanded.gif"
		imgNoSub		= "nosub.gif"
		expandAll		= "{@EXPAND_ALL}"
	/>
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
