<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="false">
	<jsp:text>
		select b.YAKU as ORGNAL,a.GENBUN,replace(b.YAKU,a.GENBUN,a.YAKU) as YAKU,b.uniq,b.fgj
		from ge28 a,ge28 b
		where instr( b.YAKU,a.GENBUN ) > 0
		and  a.kbyaku = '5'
		and  b.kbyaku != '9'
		order by b.YAKU,b.UNIQ
	</jsp:text>
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="MODIFY" accesskey="M" />
	<og:submit  value="reset"   lbl="RESET"  accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	noDisplay    = "FGJ"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
	rowspan      = "2"
>
<tr><td>[ORGNAL]</td><td>[GENBUN]</td><td>[YAKU]</td><td>[UNIQ]</td></tr>

<og:hidden name="SQL" >
  <jsp:text>
	update GF28 set YAKU = [YAKU]
	where 	UNIQ = [UNIQ]
  </jsp:text>
</og:hidden>
</og:view>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
