<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:text>{@TYPE} {@NAME}</og:text>

<og:equals val1="FUNCTION,PACKAGE,PACKAGE BODY,PROCEDURE,TYPE,TYPE BODY,TRIGGER" val2="{@TYPE}" contains="true">
	<og:value key="SQL">
		select LINE,' ' AS OK,TEXT
		from DBA_SOURCE
		where   OWNER = '{@OWNER}'
		and     TYPE  = '{@TYPE}'
		and     NAME  = '{@NAME}'
		union
		select LINE,'X' AS OK,TEXT
		from DBA_ERRORS
		where   OWNER = '{@OWNER}'
		and     NAME  = '{@NAME}'
		and     TEXT not like 'PL/SQL%ignored%'
		order by LINE,OK
	</og:value>

	<og:viewMarker command="{@command}">
		<og:columnMarker columns="LINE,OK,TEXT" onMark="[OK]" markList="X" >
			<span style="background-color:#ccff00">[$1]</span>
		</og:columnMarker>
	</og:viewMarker>
</og:equals>

<og:equals val1="TABLE" val2="{@TYPE}" >
	<og:value key="SQL">
		select TABLE_NAME,COLUMN_ID NO,COLUMN_NAME,COLUMN_NAME AS DBLABEL,DATA_TYPE,
			    (CASE WHEN DATA_PRECISION IS NULL THEN DATA_LENGTH ELSE (DATA_PRECISION+0.1*DATA_SCALE) END) AS DATA_LENGTH,
				DECODE(NULLABLE,'N','NN','') AS NN,DATA_DEFAULT
		from DBA_TAB_COLS
		where   OWNER       = '{@OWNER}'
		and     TABLE_NAME  = '{@NAME}'
		order by COLUMN_ID
	</og:value>
</og:equals>

<og:equals val1="VIEW" val2="{@TYPE}" >
	<og:value key="SQL">
		select TEXT
		from DBA_VIEWS
		where   OWNER       = '{@OWNER}'
		and     VIEW_NAME   = '{@NAME}'
	</og:value>
</og:equals>

<og:equals val1="INDEX" val2="{@TYPE}" >
	<og:value key="SQL">
		select TABLE_NAME,INDEX_NAME,COLUMN_POSITION NO,COLUMN_NAME,COLUMN_NAME AS DBLABEL,DESCEND
		from DBA_IND_COLUMNS
		where   TABLE_OWNER = '{@OWNER}'
		and     INDEX_NAME  = '{@NAME}'
		order by COLUMN_POSITION
	</og:value>
</og:equals>

<og:equals val1="SEQUENCE" val2="{@TYPE}" >
	<og:value key="SQL">
		select SEQUENCE_NAME,MIN_VALUE,MAX_VALUE,INCREMENT_BY,
				CYCLE_FLAG,ORDER_FLAG,CACHE_SIZE,LAST_NUMBER
		from DBA_SEQUENCES
		where   SEQUENCE_OWNER = '{@OWNER}'
		and     SEQUENCE_NAME  = '{@NAME}'
	</og:value>
</og:equals>

<og:equals val1="ERRORS" val2="{@TYPE}" >
	<og:value key="SQL">
		select OWNER,NAME,TYPE,LINE,POSITION,TEXT
		from DBA_ERRORS
		<og:where>
			<og:and value="OWNER	=	 '{@OWNER}'"	/>
			<og:and value="NAME	like '{@NAME}%'"	/>
			<og:and value="TEXT not like 'PL/SQL%ignored%'"	/>
		</og:where>
		order by OWNER,NAME,LINE,POSITION
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[LINE],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:query
	command      = "{@command}"
	maxRowCount  = "10000"
	notfoundMsg = ""
	quotCheck    = "false"
	dbid         = "{@DBID}" >
<jsp:text>{@SQL}</jsp:text>
</og:query>

<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="COLUMN_NAME,DBLABEL" />

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	numberType = "none"
	startNo    = "{@startNo}"
	pageSize   = "100000" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
