<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:aaa="http://java.sun.com/xml/ns/j2ee" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="aaa:taglib" />
  </xsl:template>

  <xsl:template match="aaa:taglib">
    <xsl:variable name="version" select="aaa:tlib-version" />
    <xsl:variable name="prefix"  select="aaa:short-name" />
    <ROWSET tableName="GF22">
      <EXEC_SQL>delete from GF22 where VERSION = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="aaa:tag/aaa:attribute">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="aaa:attribute" />
          </xsl:attribute>
          <VERSION><xsl:value-of select="$version" /></VERSION>
          <PREFIX><xsl:value-of select="$prefix" /></PREFIX>
          <TAGNAME><xsl:value-of select="../aaa:name" /></TAGNAME>
          <VALUENAME><xsl:value-of select="aaa:name" /></VALUENAME>
          <SEQ><xsl:number level="single" format="1" count="aaa:tag/aaa:attribute" /></SEQ>
          <TAGCLASS><xsl:value-of select="../aaa:tag-class" /></TAGCLASS>
          <REQUIRED>
            <xsl:variable name="req" select="aaa:required"/>
            <xsl:if test="$req='true'"  >1</xsl:if>
            <xsl:if test="$req='false'" >2</xsl:if>
            <xsl:if test="$req='yes'"   >3</xsl:if>
            <xsl:if test="$req='no'"    >4</xsl:if>
          </REQUIRED>
          <RTEXPRVALUE>
            <xsl:variable name="rtex" select="aaa:rtexprvalue"/>
            <xsl:if test="$rtex='true'"  >1</xsl:if>
            <xsl:if test="$rtex='false'" >2</xsl:if>
            <xsl:if test="$rtex='yes'"   >3</xsl:if>
            <xsl:if test="$rtex='no'"    >4</xsl:if>
          </RTEXPRVALUE>
          <TYPE><xsl:value-of select="aaa:type" /></TYPE>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
