<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:aaa="http://java.sun.com/xml/ns/j2ee" >

<xsl:output method="text" encoding="Shift_JIS" />

<xsl:variable name="tag_color" select="35" />
<xsl:variable name="val_color" select="255" />

<xsl:template match="/"
>// Version:<xsl:value-of select="aaa:taglib/aaa:tlib-version" />

// 99    強調表示１ （優先度最低）
// 97    強調表示２
// 161   強調表示３
// 225   強調表示４ （Interface）
// 37    行の強調表示１
// 101   行の強調表示２
// 35    特に強調表示１ （Class）
// 99    特に強調表示２ （予約語） （最優先）
<xsl:apply-templates select="aaa:taglib" />
// =========================================================
</xsl:template>

<xsl:template match="aaa:taglib">
	<xsl:for-each select="aaa:tag">
	<xsl:sort select="aaa:name" lang="ja" data-type="text" />
35,&lt;og:<xsl:value-of select="aaa:name" />
35,&lt;/og:<xsl:value-of select="aaa:name" />&gt;</xsl:for-each>

	<xsl:for-each select="//aaa:attribute">
	<xsl:sort select="aaa:name" lang="ja" data-type="text" order="ascending" />
	<xsl:if test="not(aaa:name=preceding::aaa:attribute/aaa:name)">
161,<xsl:value-of select="aaa:name" />
	</xsl:if>
	</xsl:for-each>

</xsl:template>

</xsl:stylesheet>
