/**************************************************************************/
/* GE17 ( URL転送テーブル )                                               */
/*                                                                        */
/* Created : 2009/09/15 19:52:54                                          */
/**************************************************************************/
CREATE TABLE GE17 (
   SYSTEM_ID    VARCHAR2(10)                         NOT NULL      /* 10  システムID   */
 , RANDOM_KEY   VARCHAR2(32)                         NOT NULL      /* 20  ランダムキー */
 , NAME_JA      VARCHAR2(120)                                      /* 30  名称         */
 , DYVALID      VARCHAR2(8)       DEFAULT '99999999' NOT NULL      /* 40  有効日       */
 , REDIRECT_URL VARCHAR2(4000)                       NOT NULL      /* 50  転送ＵＲＬ   */
 , UNIQ         NUMBER(9)         DEFAULT 0          NOT NULL      /* 60  ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1'        NOT NULL      /* 70  状態フラグ   */
 , DYSET        VARCHAR2(14)                                       /* 80  登録日時     */
 , DYUPD        VARCHAR2(14)                                       /* 90  更新日時     */
 , USRSET       VARCHAR2(10)                                       /* 100 作成社員     */
 , USRUPD       VARCHAR2(10)                                       /* 110 更新者       */
 , PRGUPD       VARCHAR2(10)                                       /* 120 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE17S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE17T01 
BEFORE INSERT ON GE17
FOR EACH ROW 
BEGIN 
SELECT GE17S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

