/**************************************************************************/
/* GE36 ( バッチ送信エラーテーブル )                                      */
/*                                                                        */
/* Created : 2009/09/15 19:52:54                                          */
/**************************************************************************/
CREATE TABLE GE36 (
   PARA_KEY  VARCHAR2(9)                   NOT NULL      /* 10  パラメータキー   */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 20  システムID       */
 , ERRMSG    VARCHAR2(4000)                              /* 30  エラーメッセージ */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 40  ユニークキー     */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 50  状態フラグ       */
 , DYSET     VARCHAR2(14)                                /* 60  登録日時         */
 , DYUPD     VARCHAR2(14)                                /* 70  更新日時         */
 , USRSET    VARCHAR2(10)                                /* 80  作成社員         */
 , USRUPD    VARCHAR2(10)                                /* 90  更新者           */
 , PRGUPD    VARCHAR2(10)                                /* 100 更新PRG          */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE36S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE36T01 
BEFORE INSERT ON GE36
FOR EACH ROW 
BEGIN 
SELECT GE36S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

