/*************************************************************************
 * フォーカスが当っているアクティブフィールドの色を変更します
 * 色はfocusFieldクラスで指定しています
 *
 * @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用
 * Revision: $Id$
 *************************************************************************/

var orgFldCls = null;

$(function(){
	$('textarea,select,input[type="text"]').focusin( function(){ doFocus2( this ); } );
	$('textarea,select,input[type="text"]').focusout( function(){ doBlur2( this ); } );
});

function doFocus2( obj ) {
	// 入力中のフォームの色
	if( obj != null  ) { 
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 4.3.2.2 (2008/09/16) 入力中のフォームの色をcustom.cssに指定するように変更
			orgFldCls    = obj.className;
			obj.className = 'focusField ' + orgFldCls;
		}
	}
}

function doBlur2( obj ) {
	if( obj != null ) {
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 元のフォームの色
			if( orgFldCls != null ) {
				obj.className = orgFldCls;
			}
			else {
				obj.className = 'notFocusField';
			}
		}
	}
}

/* 旧関数を呼び出した場合はアラートを出す（旧の*_inof.jsp対策） */
oldDoFocusFlag = true;
function doFocus( obj ) {
	if(oldDoFocusFlag){
		oldDoFocusFlag = false;
		setTimeout(alert("custom/query_info.jsp及びcustom/result_info.jspで次の部分を削除して下さい。\n<script>タグ（ヘッダ固定とフォーカス）、BODYのonLoadとoncontextmenu属性"),100);
	}
}
/*エラー対策の空関数 */
function doBlur( obj ) {}