/**************************************************************************/
/* GF06 ( インデックス定義 )                                              */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF06 (
   SYSTEM_ID       VARCHAR2(10)                  NOT NULL      /* 10  システムID               */
 , TBLSYU          VARCHAR2(1)                   NOT NULL      /* 20  テーブル種別             */
 , TABLE_NAME      VARCHAR2(50)                  NOT NULL      /* 30  テーブル名               */
 , INDEX_NAME      VARCHAR2(30)                  NOT NULL      /* 40  インデックス名           */
 , NAME_JA         VARCHAR2(120)                               /* 50  名称                     */
 , INDTYPE         VARCHAR2(1)                   NOT NULL      /* 60  インデックスタイプ       */
 , TABLESPACE_NAME VARCHAR2(30)                  NOT NULL      /* 70  テーブルスペース名       */
 , INITIAL_AUTO    NUMBER(10)        DEFAULT 0   NOT NULL      /* 80  自動計算初期エクステント */
 , INITIAL_EXTENT  NUMBER(10)        DEFAULT 16  NOT NULL      /* 90  初期エクステント(KB)     */
 , NEXT_EXTENT     NUMBER(10)        DEFAULT 16  NOT NULL      /* 100 ＮＥＸＴエクステント     */
 , UNIQ            NUMBER(9)         DEFAULT 0   NOT NULL      /* 110 ユニークキー             */
 , FGJ             VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 120 状態フラグ               */
 , DYSET           VARCHAR2(14)                                /* 130 登録日時                 */
 , DYUPD           VARCHAR2(14)                                /* 140 更新日時                 */
 , USRSET          VARCHAR2(10)                                /* 150 作成社員                 */
 , USRUPD          VARCHAR2(10)                                /* 160 更新者                   */
 , PRGUPD          VARCHAR2(10)                                /* 170 更新PRG                  */
 , BIKO            VARCHAR2(2000)                              /* 180 備考                     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 192K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF06S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF06T01 
BEFORE INSERT ON GF06
FOR EACH ROW 
BEGIN 
SELECT GF06S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

