/**************************************************************************/
/* GF19 ( 予約語管理テーブル )                                            */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF19 (
   DBNAME    VARCHAR2(20)                  NOT NULL      /* 10  DB名称       */
 , YOYAKU    VARCHAR2(60)                  NOT NULL      /* 20  予約語       */
 , CDYOYAKU  VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 30  予約語種別   */
 , NAME_JA   VARCHAR2(120)                               /* 40  名称         */
 , ALTERNATE VARCHAR2(1000)                              /* 50  代替候補     */
 , CONTENTS  CLOB                                        /* 60  内容         */
 , RANKCOM   VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 70  共通化ランク */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 80  ユニークキー */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 90  状態フラグ   */
 , DYSET     VARCHAR2(14)                                /* 100 登録日時     */
 , DYUPD     VARCHAR2(14)                                /* 110 更新日時     */
 , USRSET    VARCHAR2(10)                                /* 120 作成社員     */
 , USRUPD    VARCHAR2(10)                                /* 130 更新者       */
 , PRGUPD    VARCHAR2(10)                                /* 140 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF19S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF19T01 
BEFORE INSERT ON GF19
FOR EACH ROW 
BEGIN 
SELECT GF19S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

