/**************************************************************************/
/* GF65 ( プロジェクトリソース定義 )                                      */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF65 (
   PRJCODE     VARCHAR2(30)                              /* 10  PRJコード    */
 , RESOURCE_ID NUMBER(9)                                 /* 20  リソースID   */
 , SEQ         NUMBER(5)       DEFAULT 0   NOT NULL      /* 30  順           */
 , FUNCTION    VARCHAR2(2)                               /* 40  役割         */
 , UNIQ        NUMBER(9)       DEFAULT 0   NOT NULL      /* 50  ユニークキー */
 , FGJ         VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 60  状態フラグ   */
 , DYSET       VARCHAR2(14)                              /* 70  登録日時     */
 , DYUPD       VARCHAR2(14)                              /* 80  更新日時     */
 , USRSET      VARCHAR2(10)                              /* 90  作成社員     */
 , USRUPD      VARCHAR2(10)                              /* 100 更新者       */
 , PRGUPD      VARCHAR2(10)                              /* 110 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF65S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF65T01 
BEFORE INSERT ON GF65
FOR EACH ROW 
BEGIN 
SELECT GF65S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

