/**************************************************************************/
/* GF76 ( ファイル検索テーブル )                                          */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF76 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS    VARCHAR2(256)                              /* 20  アドレス     */
 , FILENAME   VARCHAR2(30)                               /* 30  ファイル名   */
 , FILEPATH   VARCHAR2(256)                              /* 40  ファイルパス */
 , MODIFIED   VARCHAR2(14)                               /* 50  最終更新日   */
 , TAGNAME    VARCHAR2(30)                               /* 60  タグ名称     */
 , TITLE      VARCHAR2(300)                              /* 70  タイトル     */
 , VERSION    VARCHAR2(10)                               /* 80  バージョン   */
 , MODIFYDATE VARCHAR2(30)                               /* 90  更新日       */
 , AUTHOR     VARCHAR2(100)                              /* 100 更新者       */
 , TEXTBODY   CLOB                                       /* 110 コメント文   */
 , FGOMIT     VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 120 除外フラグ   */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 130 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 140 状態フラグ   */
 , DYSET      VARCHAR2(14)                               /* 150 登録日時     */
 , DYUPD      VARCHAR2(14)                               /* 160 更新日時     */
 , USRSET     VARCHAR2(10)                               /* 170 作成社員     */
 , USRUPD     VARCHAR2(10)                               /* 180 更新者       */
 , PRGUPD     VARCHAR2(10)                               /* 190 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 512K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF76S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF76T01 
BEFORE INSERT ON GF76
FOR EACH ROW 
BEGIN 
SELECT GF76S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

