/**************************************************************************/
/* GF91 ( 青紙明細テーブル )                                              */
/*                                                                        */
/* Created : 2009/09/15 19:52:57                                          */
/**************************************************************************/
CREATE TABLE GF91 (
   SYSTEM_ID  VARCHAR2(10)         /* 10  システムID   */
 , PGID       VARCHAR2(30)         /* 20  プログラムID */
 , TABLE_NAME VARCHAR2(30)         /* 30  テーブル名   */
 , KBACCS     VARCHAR2(1)          /* 40  アクセス区分 */
 , BIKO       VARCHAR2(500)        /* 50  備考         */
 , UNIQ       NUMBER(9)            /* 60  ユニークキー */
 , FGJ        VARCHAR2(1)          /* 70  状態フラグ   */
 , DYSET      VARCHAR2(14)         /* 80  登録日時     */
 , DYUPD      VARCHAR2(14)         /* 90  更新日時     */
 , USRSET     VARCHAR2(10)         /* 100 登録者       */
 , USRUPD     VARCHAR2(10)         /* 110 更新者       */
 , PRGUPD     VARCHAR2(10)         /* 120 更新ＰＲＧ   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF91S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF91T01 
BEFORE INSERT ON GF91
FOR EACH ROW 
BEGIN 
SELECT GF91S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

