/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * クロス集計テーブル作成クラス用のパラメータ定数設定クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public final static で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 3.5.4.0 (2003/11/25) 新規作成
 * @og.group その他
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class ViewCrossTableParam {

	public final static String SHOKEI  = "row_hs" ;
	public final static String HEADER1 = "row_h1" ;
	public final static String HEADER2 = "row_h2" ;

	public final static String BREAK_COLUMN_KEY     = "h_breakColumn" ;
	public final static String NO_GROUP_COLUMNS_KEY = "h_noGroupColumns" ;
	public final static String SUM_NUMBER_KEY       = "h_sumNumber"   ;
	public final static String CUBE_X_COLUMN_KEY    = "h_cubeXColumn" ;
	public final static String CUBE_Y_COLUMN_KEY    = "h_cubeYColumn" ;
	public final static String SHOKEI_LABEL_KEY     = "h_shokeiLabel" ;
	public final static String GOKEI_LABEL_KEY      = "h_gokeiLabel"  ;
	public final static String CUBE_SORT_TYPE_KEY   = "h_cubeSortType" ;
	public final static String GOKEI_SORT_DIR_KEY   = "h_gokeiSortDir" ;
}
