/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.daemon;

import java.util.Date;

import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.LogWriter;

import org.opengion.hayabusa.mail.MailManager_DB;

/**
 * メールパラメータテーブルを監視して、メール送信プログラムを呼び出します。
 * このクラスは、HybsTimerTask を継承した タイマータスククラスです。
 * startDaemon() がタイマータスクによって、呼び出されます。
 *
 * @og.group メールモジュール
 *
 * @version  4.0
 * @author   Sen.Li
 * @since    JDK1.6
 */
public class MailDaemon extends HybsTimerTask {

	private int loopCnt = 0;

	private static final int LOOP_COUNTER = 24; // カウンタを24回に設定

	/**
	 * このタイマータスクによって初期化されるアクションです。
	 * パラメータを使用した初期化を行います。
	 * 
	 */
	public void initDaemon() {
		// 何もありません。(PMD エラー回避)
	}

	/**
	 * タイマータスクのデーモン処理の開始ポイントです。
	 *
	 */
	protected void startDaemon() {
		if( loopCnt % LOOP_COUNTER == 0 ) {
			loopCnt = 1;
			System.out.println( toString() + " " + new Date()  + " " );
		}
		else {
			try {
				String SystemId = getValue( "SYSTEM_ID" );
				MailManager_DB manager = new MailManager_DB(); 
				manager.sendDBMail( SystemId );
			}
			catch( RuntimeException rex ) {
					String errMsg = "メール送信失敗しました。";
					LogWriter.log( errMsg );
			}
			loopCnt++ ;
		}
	}
}
