/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public final class QueueManager_DB
implements QueueManager {
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private static final ApplicationInfo appInfo;
    private static final String CON;
    private static final String SQL_SELECT_GE50;
    private static final String SQL_UPDATE_GE50 = "update ge50 set fgkan = ?, dmn_name = ?, dmn_host = ? ,dyupd = ? where system_id = ? and ykno = ?";
    private static final String SQL_INSERT_GE56 = "insert into ge56 ( fgj, system_id, ykno, errmsg, dyset, dyupd, usrset, usrupd, prgupd )  values ( '1', ?, ? ,? ,? ,? ,? ,? ,? )";
    private static final int STATUS_COMPLETE = 2;
    private static final int STATUS_EXECUTE = 3;
    private static final int STATUS_ERROR = 8;
    private static QueueManager manager;

    private QueueManager_DB() {
    }

    public static QueueManager getInstance() {
        return manager;
    }

    @Override
    public synchronized void create() {
        String[][] stringArray = DBUtil.dbExecute((String)SQL_SELECT_GE50, (String[])new String[0], (ApplicationInfo)appInfo);
        for (int i = 0; i < stringArray.length; ++i) {
            ExecQueue execQueue = new ExecQueue();
            execQueue.setSystemId(stringArray[i][0]);
            execQueue.setYkno(stringArray[i][1]);
            execQueue.setListId(stringArray[i][2]);
            execQueue.setOutputName(new File(stringArray[i][3]).getAbsolutePath(), stringArray[i][4], stringArray[i][7], stringArray[i][1]);
            execQueue.setPdfPasswd(stringArray[i][5]);
            execQueue.setLang(stringArray[i][6]);
            execQueue.setOutputType(stringArray[i][7]);
            execQueue.setThreadId(stringArray[i][0] + "_" + StringUtil.nval((String)stringArray[i][8], (String)"_DEFALUT_"));
            execQueue.setTemplateName(new File(stringArray[i][9]).getAbsolutePath() + File.separator + stringArray[i][10]);
            execQueue.setPrinterName(stringArray[i][11]);
            execQueue.setFglocal("1".equals(stringArray[i][12]));
            execQueue.setFgcut("1".equals(stringArray[i][13]));
            execQueue.setBsql(stringArray[i][14]);
            execQueue.setHsql(stringArray[i][15]);
            execQueue.setFsql(stringArray[i][16]);
            execQueue.setManager(this);
            ExecThreadManager.insertQueue(execQueue);
        }
    }

    @Override
    public void set(ExecQueue execQueue) {
        DBTableModel dBTableModel;
        DBTableModel dBTableModel2;
        ResourceManager resourceManager = null;
        resourceManager = execQueue.isFglocal() ? ResourceFactory.newInstance(execQueue.getSystemId(), execQueue.getLang(), false) : ResourceFactory.newInstance(execQueue.getLang());
        String[] stringArray = new String[]{execQueue.getSystemId(), execQueue.getYkno()};
        DBTableModel dBTableModel3 = DBTableModelUtil.makeDBTable(execQueue.getHsql(), stringArray, resourceManager, appInfo);
        if (dBTableModel3 != null && dBTableModel3.getRowCount() > 0) {
            execQueue.setHeader(dBTableModel3);
        }
        if ((dBTableModel2 = DBTableModelUtil.makeDBTable(execQueue.getFsql(), stringArray, resourceManager, appInfo)) != null && dBTableModel2.getRowCount() > 0) {
            execQueue.setFooter(dBTableModel2);
        }
        if ((dBTableModel = DBTableModelUtil.makeDBTable(execQueue.getBsql(), stringArray, resourceManager, appInfo)) == null) {
            execQueue.addMsg("[ERROR] DBTableModel doesn't exists! maybe Layout-Table(GE52) is not configured..." + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        if (dBTableModel.getRowCount() <= 0) {
            execQueue.addMsg("[ERROR] Database Body row count is Zero." + execQueue.getBsql() + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        if (dBTableModel.isOverflow()) {
            execQueue.addMsg("[ERROR]Database is Overflow. [" + dBTableModel.getRowCount() + "]" + HybsSystem.CR);
            execQueue.addMsg("[ERROR]Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow" + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        execQueue.setBody(dBTableModel);
    }

    @Override
    public void execute(ExecQueue execQueue) {
        this.status(execQueue, 3);
    }

    @Override
    public void complete(ExecQueue execQueue) {
        this.status(execQueue, 2);
    }

    @Override
    public void error(ExecQueue execQueue) {
        this.status(execQueue, 8);
        this.insertErrorMsg(execQueue);
    }

    private void status(ExecQueue execQueue, int n) {
        String string = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] stringArray = new String[]{String.valueOf(n), execQueue.getThreadId(), HybsSystem.sys("HOST_NAME"), string, execQueue.getSystemId(), execQueue.getYkno()};
        DBUtil.dbExecute((String)SQL_UPDATE_GE50, (String[])stringArray, (ApplicationInfo)appInfo);
    }

    private void insertErrorMsg(ExecQueue execQueue) {
        String string = execQueue.getMsg();
        if (string.length() > 1300) {
            string = string.substring(string.length() - 1300, string.length());
        }
        String string2 = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] stringArray = new String[]{execQueue.getSystemId(), execQueue.getYkno(), string, string2, string2, "UNKNOWN", "UNKNOWN", "UNKNOWN"};
        DBUtil.dbExecute((String)SQL_INSERT_GE56, (String[])stringArray, (ApplicationInfo)appInfo);
        this.sendMail(execQueue, string);
    }

    private void sendMail(ExecQueue execQueue, String string) {
        String string2 = HybsSystem.sys("COMMON_MAIL_SERVER");
        String string3 = HybsSystem.sys("ERROR_MAIL_FROM_USER");
        String[] stringArray = StringUtil.csv2Array((String)HybsSystem.sys("ERROR_MAIL_TO_USERS"));
        if (string2 != null && string3 != null && stringArray.length > 0) {
            String string4 = "SYSTEM_ID=[" + execQueue.getSystemId() + "] , YKNO=[" + execQueue.getYkno() + "] , " + "THREAD_ID=[" + execQueue.getThreadId() + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "]";
            try {
                MailTX mailTX = new MailTX(string2);
                mailTX.setFrom(string3);
                mailTX.setTo(stringArray);
                mailTX.setSubject("\u5e33\u7968\u30a8\u30e9\u30fc\uff1a" + string4);
                mailTX.setMessage(string);
                mailTX.sendmail();
            }
            catch (Throwable throwable) {
                String string5 = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + string4 + HybsSystem.CR + throwable.getMessage();
                LogWriter.log((String)string5);
                LogWriter.log((Throwable)throwable);
            }
        }
    }

    static {
        if (USE_DB_APPLICATION_INFO) {
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo("ReportDaemon", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("ReportDaemon", "QueueManager", "QueueManager");
        } else {
            appInfo = null;
        }
        CON = DBFunctionName.getFunctionName((String)"CON", (String)ConnectionFactory.getDBFullName(null));
        SQL_SELECT_GE50 = "select a.system_Id, a.ykno, a.listid, a.outdir, a.outfile, a.pdf_passwd, b.lang, b.fgrun, b.dmn_grp , c.modeldir, c.modelfile, d.prtnm, c.fglocal, c.fgcut, c.bsql, c.hsql, c.fsql from ge50 a inner join ge53 b on a.system_id = b.system_id and a.joken = b.joken inner join ge54 c on a.system_id = c.system_id and a.listid = c.listid left outer join ge55 d on b.system_id = d.system_id and b.prtid = d.prtid where a.fgkan='1' and exists ( select 'X' from ge12 e where\te.fgj\t\t\t\t='1' and\t\te.system_id \t= '" + HybsSystem.sys("SYSTEM_ID") + "' " + "and\t\te.contxt_path\t= '" + HybsSystem.sys("HOST_URL") + "' " + "and\t\te.param_id\t\tlike 'REPORT2_HANDLE_DAEMON_%' " + "and\t\te.param\t\t\t= 'RUN_'" + CON + "a.system_id" + CON + "'_'" + CON + "b.dmn_grp" + ") " + "order by " + HybsSystem.sys("REPORT_DAEMON_ORDER_BY");
        manager = new QueueManager_DB();
    }
}

