/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.HashSet;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.RoleMode;

public final class CodeData {
    private final boolean USE_MULTI_KEY_SELECT = HybsSystem.sysBool("USE_MULTI_KEY_SELECT");
    private static final String SPC = "";
    public static final int CLM = 0;
    public static final int CODE = 1;
    public static final int LNAME = 2;
    public static final int SNAME = 3;
    public static final int CODELVL = 4;
    public static final int CODEGRP = 5;
    public static final int CODE_PARAM = 6;
    public static final int ROLES = 7;
    public static final int SYSTEM_ID = 8;
    public static final int KBSAKU = 9;
    public static final int RSNAME = 10;
    private final String column;
    private final String[] code;
    private final String[] longLabel;
    private final String[] shortLabel;
    private final String[] codelebel;
    private final String[] codeGroup;
    private final String[] codeParam;
    private final String[] roles;
    private final int size;
    private final boolean isMultiSelect;
    private final RoleMode[] roleModes;
    private final String[] rawShortLabel;

    CodeData(String string, Map<String, String[]> map) {
        this.column = string;
        this.size = map.size();
        String[] stringArray = map.keySet().toArray(new String[this.size]);
        this.code = new String[this.size];
        this.shortLabel = new String[this.size];
        this.longLabel = new String[this.size];
        this.codelebel = new String[this.size];
        this.codeGroup = new String[this.size];
        this.codeParam = new String[this.size];
        this.roles = new String[this.size];
        this.roleModes = new RoleMode[this.size];
        this.rawShortLabel = new String[this.size];
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.USE_MULTI_KEY_SELECT;
        for (int i = 0; i < this.size; ++i) {
            String string2;
            String[] stringArray2 = map.get(stringArray[i]);
            this.code[i] = StringUtil.nval2((String)stringArray2[1], (String)SPC);
            this.longLabel[i] = string2 = StringUtil.nval2((String)stringArray2[2], (String)SPC);
            this.shortLabel[i] = StringUtil.nval2((String)stringArray2[3], (String)string2);
            this.codelebel[i] = StringUtil.nval2((String)stringArray2[4], (String)SPC);
            this.codeGroup[i] = StringUtil.nval2((String)stringArray2[5], (String)SPC);
            this.codeParam[i] = StringUtil.nval2((String)stringArray2[6], (String)SPC);
            this.roles[i] = StringUtil.nval2((String)stringArray2[7], (String)SPC);
            this.roleModes[i] = RoleMode.newInstance(this.roles[i]);
            this.rawShortLabel[i] = StringUtil.nval2((String)stringArray2[10], (String)string2);
            if (!bl || string2.length() <= 0) continue;
            bl = hashSet.add(string2.substring(0, 1));
        }
        this.isMultiSelect = this.USE_MULTI_KEY_SELECT && !bl;
    }

    public String getColumn() {
        return this.column;
    }

    public String getCodeKey(int n) {
        return this.code[n];
    }

    public String getLongLabel(int n) {
        return this.longLabel[n];
    }

    public String getShortLabel(int n) {
        return this.shortLabel[n];
    }

    public String getCodeLebel(int n) {
        return this.codelebel[n];
    }

    public boolean getCodeGroup(int n, String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return this.codeGroup[n].indexOf(string) >= 0;
    }

    public String getCodeParam(int n) {
        return this.codeParam[n];
    }

    public String getRoles(int n) {
        return this.roles[n];
    }

    public RoleMode getRoleMode(int n) {
        return this.roleModes[n];
    }

    public int getAddress(String string) {
        int n = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!this.code[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getSize() {
        return this.size;
    }

    public boolean useMultiSelect() {
        return this.isMultiSelect;
    }

    public String toCodeString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.size; ++i) {
            String string = this.code[i] + ":";
            if (!this.longLabel[i].startsWith(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(this.longLabel[i]);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public String getRawShortLabel(int n) {
        return this.rawShortLabel[n];
    }

    public String toString() {
        return "column = " + this.toCodeString();
    }
}

