/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.RoleMode;

public final class GUIData {
    public static final int GUIKEY = 0;
    public static final int GUILVL = 1;
    public static final int LABEL_CLM = 2;
    public static final int ADDRESS = 3;
    public static final int SEQNO = 4;
    public static final int GROUPS = 5;
    public static final int CLASSIFY = 6;
    public static final int ROLES = 7;
    public static final int RWMODE = 8;
    public static final int TARGET = 9;
    public static final int PARAM = 10;
    public static final int KBLINK = 11;
    public static final int DATA_SIZE = 12;
    private final String guiKey;
    private final int guiLevel;
    private final String lblClm;
    private final String address;
    private final String realAddress;
    private final int seqno;
    private final String groups;
    private final String classify;
    private final String target;
    private final String param;
    private final String kblink;
    private final boolean pageUse;
    private final RoleMode roleMode;
    private static final String CON_DIR = "/" + HybsSystem.getContextName() + "/";

    GUIData(String[] stringArray) {
        this.guiKey = stringArray[0].intern();
        this.guiLevel = Integer.parseInt(stringArray[1]);
        this.lblClm = StringUtil.nval2((String)stringArray[2], (String)this.guiKey);
        this.address = stringArray[3].intern();
        this.seqno = Integer.parseInt(stringArray[4]);
        this.groups = StringUtil.nval2((String)stringArray[5], null);
        this.classify = StringUtil.nval2((String)stringArray[6], (String)"");
        this.roleMode = RoleMode.newInstance(stringArray[7], stringArray[8]);
        this.target = StringUtil.nval2((String)stringArray[9], null);
        if (this.address.startsWith("http://") || this.address.startsWith("https://") || this.address.startsWith(".")) {
            this.kblink = "http";
            this.pageUse = false;
            this.realAddress = this.address;
        } else {
            this.pageUse = true;
            this.kblink = StringUtil.nval2((String)stringArray[11], (String)"jsp");
            this.realAddress = this.kblink.startsWith("/") ? this.kblink + "/" + this.address + "/" : CON_DIR + this.kblink + "/" + this.address + "/";
        }
        String string = stringArray[10];
        this.param = string != null && string.length() > 0 ? string.intern() : "";
    }

    public String getGuiKey() {
        return this.guiKey;
    }

    public int getGuiLevel() {
        return this.guiLevel;
    }

    public String getLabelClm() {
        return this.lblClm;
    }

    public String getAddress() {
        return this.address;
    }

    public String getRealAddress() {
        return this.realAddress;
    }

    public String getRealAddress(String string) {
        if (!this.pageUse || string == null) {
            return this.realAddress;
        }
        return this.realAddress + string;
    }

    public int getSeqno() {
        return this.seqno;
    }

    public String getGroups() {
        return this.groups;
    }

    public String getClassify() {
        return this.classify;
    }

    public String getRoles() {
        return this.roleMode.getRoles();
    }

    public String getMode() {
        return this.roleMode.getMode();
    }

    public RoleMode getRoleMode() {
        return this.roleMode;
    }

    public String getTarget() {
        return this.target;
    }

    public String getParam() {
        return this.param;
    }

    public String getKblink() {
        return this.kblink;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("guiKey     :").append(this.guiKey).append(HybsSystem.CR);
        stringBuilder.append("guiLevel   :").append(this.guiLevel).append(HybsSystem.CR);
        stringBuilder.append("address    :").append(this.address).append(HybsSystem.CR);
        stringBuilder.append("realAddress:").append(this.realAddress).append(HybsSystem.CR);
        stringBuilder.append("seqno      :").append(this.seqno).append(HybsSystem.CR);
        stringBuilder.append("classify   :").append(this.classify).append(HybsSystem.CR);
        stringBuilder.append("roles      :").append(this.getRoles()).append(HybsSystem.CR);
        stringBuilder.append("mode       :").append(this.getMode()).append(HybsSystem.CR);
        stringBuilder.append("target     :").append(this.target).append(HybsSystem.CR);
        stringBuilder.append("param      :").append(this.param).append(HybsSystem.CR);
        stringBuilder.append("kblink     :").append(this.kblink).append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

