/**************************************************************************/
/* GE56 ( 帳票エラーテーブル )                                            */
/*                                                                        */
/* Created : 2009/11/04 19:23:38                                          */
/**************************************************************************/
CREATE TABLE GE56 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID       */
 , YKNO      NUMBER(9)         DEFAULT 0   NOT NULL      /* 20  要求ＮＯ         */
 , ERRMSG    VARCHAR2(4000)                              /* 30  エラーメッセージ */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 40  状態フラグ       */
 , UNIQSEQ   NUMBER(9)         DEFAULT 0   NOT NULL      /* 50  シーケンス番号   */
 , DYSET     VARCHAR2(14)                                /* 60  登録日時         */
 , DYUPD     VARCHAR2(14)                                /* 70  更新日時         */
 , USRSET    VARCHAR2(10)                                /* 80  作成社員         */
 , USRUPD    VARCHAR2(10)                                /* 90  更新者           */
 , PRGUPD    VARCHAR2(10)                                /* 100 更新PRG          */
)
TABLESPACE GETBL01
STORAGE( INITIAL 704K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE56S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE56T01 
BEFORE INSERT ON GE56
FOR EACH ROW 
BEGIN 
SELECT GE56S01.NEXTVAL INTO :NEW.UNIQSEQ FROM DUAL; 
END; 
/

