/**************************************************************************/
/* GEA03 ( カラム定義 )                                                   */
/*                                                                        */
/* Created : 2009/11/04 19:23:38                                          */
/**************************************************************************/
CREATE TABLE GEA03 (
   SYSTEM_ID      VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , CLM            VARCHAR2(30)                 NOT NULL      /* 20  項目             */
 , NAME_JA        VARCHAR2(120)                              /* 30  名称             */
 , CLS_NAME       VARCHAR2(10)                               /* 40  DBクラス         */
 , USE_LENGTH     VARCHAR2(9)      DEFAULT '0' NOT NULL      /* 50  使用桁数         */
 , VIEW_LENGTH    VARCHAR2(10)                               /* 60  表示桁数         */
 , RENDERER       VARCHAR2(10)                               /* 70  表示種別         */
 , EDITOR         VARCHAR2(10)                               /* 80  編集種別         */
 , DBTYPE         VARCHAR2(10)                               /* 90  文字種別         */
 , DATA_DEFAULT   VARCHAR2(30)                               /* 100 初期値           */
 , LABEL_CLM      VARCHAR2(30)                               /* 110 ラベルカラム     */
 , CODE_CLM       VARCHAR2(30)                               /* 120 コードカラム     */
 , RENDERER_PARAM VARCHAR2(200)                              /* 130 表示パラメータ   */
 , EDITOR_PARAM   VARCHAR2(200)                              /* 140 編集パラメータ   */
 , TYPE_PARAM     VARCHAR2(200)                              /* 150 文字パラメータ   */
 , COMMENTS       VARCHAR2(500)                              /* 160 コメント         */
 , CDKH           VARCHAR2(1)                                /* 170 改廃コード       */
 , FGLOAD         VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 180 読込F            */
 , KBSAKU         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 190 作成区分         */
 , UNIQ           NUMBER(9)        DEFAULT 0   NOT NULL      /* 200 ユニークキー     */
 , FGJ            VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 210 状態フラグ       */
 , DYSET          VARCHAR2(14)                               /* 220 登録日時         */
 , DYUPD          VARCHAR2(14)                               /* 230 更新日時         */
 , USRSET         VARCHAR2(10)                               /* 240 作成社員         */
 , USRUPD         VARCHAR2(10)                               /* 250 更新者           */
 , PRGUPD         VARCHAR2(10)                               /* 260 更新PRG          */
 , RELEASE_NOTES  VARCHAR2(120)                              /* 270 リリースノート   */
 , RDC_CODE       VARCHAR2(20)                               /* 280 設変番号         */
 , ROLES          VARCHAR2(500)                              /* 290 ロールズ         */
 , CLM_PARAM      VARCHAR2(200)                              /* 300 カラムパラメータ */
)
TABLESPACE GETBL01
STORAGE( INITIAL 576K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA03S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA03T01 
BEFORE INSERT ON GEA03
FOR EACH ROW 
BEGIN 
SELECT GEA03S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

