<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL04"
	title	= "社員検索"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
		SELECT	 USERID MEMBER
				,NAME
				,'1' NM_KBN
		FROM	GE35
	<og:where>
		<og:and value = "USERID		like	'{@USERID}%'"	/>
		<og:and value = "NAME			like	'{@NAME}%'"		/>
		<og:and value = "NVL(FGJ,'0')	!=		'9'"			/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "USERID" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- DB検索結果を表示させます。 -->
<og:view
	scope        = "request"
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "NM_KBN"
	selectedType = "radio"
	popupReturnKeys = "MEMBER,NAME,NM_KBN"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
