<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2010"
	title	= "テーブル"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "SYSTEM_ID"
/>

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select TABLE_NAME,TABLESPACE_NAME,TABLE_NAME AS NAME_JA,
				1000 AS SKENSU,0 AS JKENSU,
				INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				NEXT_EXTENT/1024 AS NEXT_EXTENT,'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_TABLES
		<og:where>
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value = "INSTR(TABLE_NAME,'$') &lt; 1" />
		</og:where>
		order by TABLE_NAME
	</jsp:text>
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "NEW"
	columnWritable   = "NAME_JA,SKENSU,INITIAL_EXTENT,COMMENTS"
	checked    = "true"
	startNo    = "{@startNo}"
	pageSize   = "10000" />

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GF02
		(TBLSYU,TABLE_NAME,NAME_JA,SKENSU,JKENSU,TABLESPACE_NAME,INITIAL_EXTENT,COMMENTS,
		 SYSTEM_ID,INITIAL_AUTO,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([TBLSYU],[TABLE_NAME],[NAME_JA],[SKENSU],[JKENSU],[TABLESPACE_NAME],[INITIAL_EXTENT],[COMMENTS],
		 [SYSTEM_ID],16,
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
  </jsp:text>
</og:hidden>

<og:hidden name="SQL2" >
  <jsp:text>
	DELETE FROM GF02 WHERE TBLSYU = [TBLSYU] AND TABLE_NAME = [TABLE_NAME] AND SYSTEM_ID = [SYSTEM_ID]
  </jsp:text>
</og:hidden>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
