<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX004"
	title	= "クイックリファレンス"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select  a.SEQ,a.TAGNAME,b.HTMLEXT,b.DESCRIPTION,a.BODYCONTENT
		from    GF21 a left outer join GF23 b
		on		a.VERNO     = b.VERNO
		and		a.TAGCLASS    = b.TAGCLASS
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERNO     = '{@VERNO}'"   />
		<og:and value = "a.PRE_FIX      = '{@PRE_FIX}'"    />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<jsp:text>order by a.VERNO,a.TAGNAME</jsp:text>
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:viewMarker command="{@command}">
	<og:columnMarker column="TAGNAME" >
		<a name="TAG_[TAGNAME]" />
		<a href="#VAL_[TAGNAME]" alt="[TAGNAME]">[TAGNAME]</a>
	</og:columnMarker>
</og:viewMarker>

<div style="font-size: x-large">
	<og:message lbl="TAGNAME" />
	(<og:message lbl="VERNO" /> <og:message lbl="{@VERNO}" />)
</div>

<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	writable     = "false"
	pageSize     = "1000"
	headerSkipCount = "0"
	backLinkCount   = "10"
	useTableSorter	= "false"
	useScrollBar	= "false"
/>

<div style="page-break-before: always" ></div>

<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select  a.VERNO,a.PRE_FIX || ':' || a.TAGNAME as TAGNAME2,
				a.PRE_FIX,a.TAGNAME,a.SEQ,a.VALUENAME,a.REQUIRED,
				b.DESCRIPTION,b.HTMLEXT,c.BODYCONTENT,'0' as DATAKEY
		from    GF22 a left outer join GF24 b
		on		a.VERNO   = b.VERNO
		and		a.TAGCLASS  = b.TAGCLASS
		and		a.VALUENAME = b.VALUENAME
		and		a.FGJ       = b.FGJ
					left outer join GF21 c
					on	a.VERNO   = c.VERNO
					and	a.PRE_FIX    = c.PRE_FIX
					and	a.TAGNAME   = c.TAGNAME
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERNO     LIKE '{@VERNO}%'"      />
		<og:and value = "a.PRE_FIX      =    '{@PRE_FIX}'"        />
		<og:and value = "a.TAGNAME     LIKE '{@TAGNAME}%'"      />
		<og:and value = "a.VALUENAME   LIKE '{@VALUENAME}%'"    />
		<og:and value = "b.DESCRIPTION LIKE '%{@DESCRIPTION}%'" />
		<og:and value = "a.FGJ         in   ( '0','1' )"        />
	</og:where>
	<jsp:text>
		union
		select VERNO,PRE_FIX || ':' || TAGNAME as TAGNAME2,PRE_FIX,TAGNAME,999 as SEQ,
				'' as VALUENAME,'' as REQUIRED,'' as DESCRIPTION,'' as HTMLEXT,
				BODYCONTENT,BODYCONTENT as DATAKEY
		from GF21
	</jsp:text>
	<og:where>
		<og:and value = "VERNO     LIKE '{@VERNO}%'"      />
		<og:and value = "PRE_FIX      =    '{@PRE_FIX}'"        />
		<og:and value = "TAGNAME     LIKE '{@TAGNAME}%'"      />
		<og:and value = "FGJ         in   ( '0','1' )"        />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<jsp:text>order by 1,4,5</jsp:text>
</og:query>

<og:viewMarker command="{@command}">
	<og:columnMarker column="TAGNAME2" >
		<a name="VAL_[TAGNAME]" />
		<a href="#TAG_[TAGNAME]" alt="[TAGNAME]">[TAGNAME2]</a>
	</og:columnMarker>
	<og:columnMarker column="VALUENAME"  onMark="[VALUENAME]"
			markList="chartClass|dbType|editor|queryType|readerClass|renderer|viewFormType|writerClass|calDB|" >
		<a name="VAL_[VALUENAME]" />
		<a href="#CLS_[VALUENAME]" alt="[VALUENAME]">[VALUENAME]</a>
	</og:columnMarker>
	<og:columnMarker column="DESCRIPTION"  onMark="[REQUIRED]" markList="1" >
		<span style="color:green;">[DESCRIPTION]({@LBL.REQUIRED})</span>
	</og:columnMarker>
</og:viewMarker>

<div style="font-size: x-large">
	<og:message lbl="VALUENAME" />
	(<og:message lbl="VERNO" /> <og:message lbl="{@VERNO}" />)
</div>
<og:view
	viewFormType = "HTMLCustomTable"
	command 	 = "{@command}"
	writable     = "false"
	startNo      = "{@startNo}"
	pageSize     = "2000"
	rowspan		 = "1"
	numberType	 = "delete"
	useTableSorter	= "false"
	useScrollBar	= "false"
>
	<og:thead rowspan="1" >
		<tr><td>&amp;nbsp;</td><td>[VALUENAME]</td><td>[DESCRIPTION]</td></tr>
	</og:thead>

	<og:tbody usableKey="SEQ" usableList="1" rowspan="1">
		<tr><td colspan="2">&amp;lt;[TAGNAME2]</td><td></td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="0" rowspan="1">
		<tr><td>&amp;nbsp;&amp;nbsp;</td><td>[VALUENAME]</td>
			<td>= "[DESCRIPTION]"</td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="1" rowspan="2">
		<tr><td>&amp;gt;</td><td>... Body ...</td><td></td><td></td></tr>
		<tr><td colspan="3">&amp;lt;/[TAGNAME2]&amp;gt;</td><td></td><td></td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="2" rowspan="1">
		<tr><td>/&amp;gt;</td><td></td><td></td><td></td></tr>
	</og:tbody>

</og:view>

<div style="page-break-before: always" ></div>

<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select  VALUENAME,ATTKEY,DESCRIPTION
		from    GF25
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "VERNO      =    '{@VERNO}'"        />
		<og:and value = "FGJ in ( '0','1' )"                    />
	</og:where>
	<jsp:text>order by VERNO,SEQ,ATTKEY</jsp:text>
</og:query>

<og:viewMarker command="{@command}">
	<og:columnMarker column="VALUENAME" >
		<a name="CLS_[VALUENAME]" />
		<a href="#VAL_[VALUENAME]" alt="[VALUENAME]">[VALUENAME]</a>
	</og:columnMarker>
</og:viewMarker>

<div style="font-size: x-large">
	<og:message lbl="ATTCLASS" />
	(<og:message lbl="VERNO" /> <og:message lbl="{@VERNO}" />)
</div>
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	writable     = "false"
	pageSize     = "1000"
	headerSkipCount = "0"
	backLinkCount   = "10"
	useTableSorter	= "false"
	useScrollBar	= "false"
/>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
