/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class Selection_DB
implements Selection {
    private final boolean USE_MULTI_KEY_SELECT = HybsSystem.sysBool("USE_MULTI_KEY_SELECT");
    private final long DB_CACHE_TIME = HybsSystem.sysInt("DB_CACHE_TIME");
    private final boolean isMultiSelect;
    private final boolean isShortLavel;
    private final long createTime;
    private final int[] ADRS;
    private final String CASHE;
    private final int LEN;
    private final Map<String, Integer> map;
    private final String[] value;
    private final String[] label;
    private final String[] slabel;
    private static final int VAL = 0;
    private static final int LBL = 1;
    private static final int SLBL = 2;
    private static final int GRP = 3;
    private static final int CLS = 4;
    private static final ApplicationInfo appInfo;

    public Selection_DB(String string, String string2, String string3) {
        String[][] stringArray = DBUtil.dbExecute((String)string, null, (ApplicationInfo)appInfo, (String)string2);
        int n = stringArray.length;
        this.value = new String[n];
        this.label = new String[n];
        this.slabel = new String[n];
        this.ADRS = new int[n];
        this.map = new HashMap<String, Integer>(n);
        int n2 = n > 0 ? stringArray[0].length : 0;
        this.isShortLavel = n2 > 2;
        boolean bl = n2 > 3;
        boolean bl2 = n2 > 4;
        boolean bl3 = false;
        ResourceManager resourceManager = null;
        if (n2 == 1) {
            bl3 = true;
            resourceManager = ResourceFactory.newInstance(string3);
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl4 = this.USE_MULTI_KEY_SELECT;
        StringBuilder stringBuilder = new StringBuilder(500);
        String string4 = "";
        for (int i = 0; i < n; ++i) {
            String string5;
            this.value[i] = stringArray[i][0];
            if (bl3) {
                this.label[i] = resourceManager.getLabel(this.value[i]);
            } else {
                this.label[i] = stringArray[i][1];
                if (this.isShortLavel) {
                    this.slabel[i] = stringArray[i][2];
                }
            }
            this.map.put(this.value[i], i);
            if (bl && !(string5 = stringArray[i][3]).equals(string4)) {
                if (!"".equals(string4)) {
                    stringBuilder.append("</optgroup>");
                }
                if (!"".equals(string5)) {
                    stringBuilder.append("<optgroup label=\"" + string5 + "\">");
                }
                string4 = string5;
            }
            stringBuilder.append("<option value=\"").append(this.value[i]).append("\"");
            this.ADRS[i] = stringBuilder.length();
            if (bl2 && !"".equals(string5 = stringArray[i][4])) {
                stringBuilder.append(" class=\"").append(string5).append("\"");
            }
            if (this.isShortLavel) {
                if (!this.label[i].equals(this.slabel[i])) {
                    stringBuilder.append(" title=\"").append(this.label[i]).append("\"");
                }
                stringBuilder.append(">").append(this.slabel[i]);
            } else {
                stringBuilder.append(">").append(this.label[i]);
            }
            stringBuilder.append("</option>");
            if (!bl4 || this.label[i].length() <= 0) continue;
            bl4 = hashSet.add(this.label[i].substring(0, 1));
        }
        if (bl && !"".equals(string4)) {
            stringBuilder.append("</optgroup>");
        }
        this.CASHE = stringBuilder.toString();
        this.LEN = this.CASHE.length() + 30;
        this.isMultiSelect = this.USE_MULTI_KEY_SELECT && !bl4;
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public String getOption(String string, boolean bl) {
        Integer n = this.map.get(string);
        if (n == null) {
            if (string != null && string.length() > 0) {
                String string2 = "DB\u30b3\u30fc\u30c9\u306b\u5b58\u5728\u3057\u306a\u3044\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002 Value=[" + string + "]" + HybsSystem.CR;
                LogWriter.log((String)string2);
            }
            return this.CASHE;
        }
        int n2 = n;
        StringBuilder stringBuilder = new StringBuilder(this.LEN);
        if (bl) {
            stringBuilder.append("<option value=\"").append(this.value[n2]).append("\"");
        } else {
            stringBuilder.append(this.CASHE.substring(0, this.ADRS[n2]));
        }
        stringBuilder.append(" selected=\"selected\"");
        stringBuilder.append(this.CASHE.substring(this.ADRS[n2]));
        return stringBuilder.toString();
    }

    @Override
    public String getRadio(String string, String string2, boolean bl) {
        String string3 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public String getRadioLabel(String string) {
        String string2 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public String getValueLabel(String string) {
        return this.getValueLabel(string, false);
    }

    @Override
    public String getValueLabel(String string, boolean bl) {
        Integer n = this.map.get(string);
        if (n == null) {
            return string;
        }
        if (this.isShortLavel && bl) {
            return this.slabel[n];
        }
        return this.label[n];
    }

    @Override
    public boolean useMultiSelect() {
        return this.isMultiSelect;
    }

    @Override
    public boolean isTimeOver() {
        return System.currentTimeMillis() - this.createTime > this.DB_CACHE_TIME;
    }

    static {
        boolean bl = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
        if (bl) {
            String string = HybsSystem.sys("SYSTEM_ID");
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("Selection_DB", null, null);
        } else {
            appInfo = null;
        }
    }
}

