/**************************************************************************/
/* GF23 ( TAGLIB使用例ファイル )                                          */
/*                                                                        */
/* Created : 2009/12/10 12:29:44                                          */
/**************************************************************************/
CREATE TABLE GF23 (
   VERNO       VARCHAR2(10)                  NOT NULL      /* 10  バージョン   */
 , TAGCLASS    VARCHAR2(100)                 NOT NULL      /* 20  TAGクラス名  */
 , HTMLEXT     VARCHAR2(1)                                 /* 30  HTMLEXT      */
 , DESCRIPTION VARCHAR2(4000)                              /* 40  概要説明     */
 , CONTENTS    CLOB                                        /* 50  内容         */
 , FORM_SAMPLE CLOB                                        /* 60  形式サンプル */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 820 登録日時     */
 , PGSET       VARCHAR2(10)                                /* 830 作成PG       */
 , PGPSET      VARCHAR2(10)                                /* 840 作成親PG     */
 , USRSET      VARCHAR2(10)                                /* 850 作成社員     */
 , DYUPD       VARCHAR2(14)                                /* 860 更新日時     */
 , PGUPD       VARCHAR2(10)                                /* 870 更新PG       */
 , PGPUPD      VARCHAR2(10)                                /* 880 更新親PG     */
 , USRUPD      VARCHAR2(10)                                /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 14336K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF23S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF23T01 
BEFORE INSERT ON GF23
FOR EACH ROW 
BEGIN 
SELECT GF23S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

