/**************************************************************************/
/* GF92 ( 画面項目定義テーブル )                                          */
/*                                                                        */
/* Created : 2009/12/10 12:29:44                                          */
/**************************************************************************/
CREATE TABLE GF92 (
   SYSTEM_ID   VARCHAR2(10)                               /* 10  システムID     */
 , PGID        VARCHAR2(30)                 NOT NULL      /* 20  PG-ID          */
 , NMSYORI     VARCHAR2(100)                              /* 30  処理グループ名 */
 , SEQ         NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  順             */
 , CLM         VARCHAR2(30)                               /* 50  項目           */
 , KBACCS      VARCHAR2(1)                                /* 60  KBACCS         */
 , MUST        VARCHAR2(10)                               /* 70  必須           */
 , DEFAULT_VAL VARCHAR2(100)                              /* 80  デフォルト値   */
 , TABLE_NAME  VARCHAR2(50)                 NOT NULL      /* 90  テーブル名     */
 , ZOKUSEI     VARCHAR2(500)                              /* 100 属性（桁数）   */
 , SETU        VARCHAR2(500)                              /* 110 項目説明       */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 120 ユニークキー   */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 130 状態フラグ     */
 , DYSET       VARCHAR2(14)                               /* 140 登録日時       */
 , PGSET       VARCHAR2(10)                               /* 150 作成PG         */
 , PGPSET      VARCHAR2(10)                               /* 160 作成親PG       */
 , USRSET      VARCHAR2(10)                               /* 170 作成社員       */
 , DYUPD       VARCHAR2(14)                               /* 180 更新日時       */
 , PGUPD       VARCHAR2(10)                               /* 190 更新PG         */
 , PGPUPD      VARCHAR2(10)                               /* 200 更新親PG       */
 , USRUPD      VARCHAR2(10)                               /* 210 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF92S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF92T01 
BEFORE INSERT ON GF92
FOR EACH ROW 
BEGIN 
SELECT GF92S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

