<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC18"
	title	= "JSP解析"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID,PATH,PROG"
/>

<!-- GF70_PROG.xsl ～ GF77_PROG.xsl までを選択します。  -->
<og:value key="XSLT_PATH" value="{@SYS.REAL_PATH}jsp/{@GUI.ADDRESS}/xslt" />
<og:value key="XSL_FILE"  value="GF7{@PROG}_PROG.xsl" />
<og:value key="OUT_FILE"  value="GF7{@PROG}_PROG.xml" />
<og:value key="TBL"       value="GF7{@PROG}" />
<og:value key="FGOMIT"    value=" and FGOMIT='0'" />
<og:equals val1="{@PROG}" val2="7">
	<og:value key="FGOMIT" command="REMOVE" />
</og:equals>

<pre>
<og:mainProcess useThread="false" useJspLog="{@debug}" useDisplay="true">
  <og:process processID="FileSearch">
    <og:param key="start"		value="{@PATH}" />
    <og:param key="suffix"		value=".jsp" />
    <og:param key="maxLevel"	value="2"	 />
  </og:process>
  <og:process processID="Grep">
    <og:param key="keyword"	value="&lt;jsp:root" />
    <og:param key="display"	value="true" />
  </og:process>
  <og:process processID="XSLT">
    <og:param key="xslfile"			value="{@XSLT_PATH}/{@XSL_FILE}" />
    <og:param key="outfile"			value="{@XSLT_PATH}/{@OUT_FILE}" />
    <og:param key="useFileInfo"		value="true" />
    <og:param key="param_SYSTEM_ID"	value="{@SYSTEM_ID}" />
    <og:param key="header1"			value='&lt;?xml version="1.0" encoding="UTF-8"?&gt;' />
    <og:param key="header2"			value='&lt;ROWSET tableName="{@TBL}"&gt;' />
    <og:param key="header3"			value="&lt;EXEC_SQL&gt;delete from {@TBL} where SYSTEM_ID='{@SYSTEM_ID}' and FGOMIT='0' and FILEPATH like '{@PATH}%' &lt;/EXEC_SQL&gt;" />
    <og:param key="footer"				value="&lt;/ROWSET&gt;" />
    <og:param key="errAbend"			value="false" />
    <og:param key="errXmlIn"			value="true" />
    <og:param key="jspInclude"			value="{@jspInclude}" />
  </og:process>
</og:mainProcess>

<br />
==========================================================================
<br />

<og:directXMLSave
	fileURL  = "{@XSLT_PATH}/"
	filename = "{@OUT_FILE}"
/>
</pre>

<br />
==========================================================================
<br />
<!-- DOC10 ～ DOC17 までを選択します。  -->
<og:link gamenId="DOC1{@PROG}" href="index.jsp" target="CONTENTS"
	keys="command,SYSTEM_ID" vals="NEW,{@SYSTEM_ID}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
