<og:query command="{@command}" debug="{@debug}" dbid="{@DBID1}" maxRowCount="{@maxRowCount}">
	select	'1' WRITABLE, TABLE_NAME,CLM,NAME_JA,CLS_NAME,
			NVL(EDITOR,(CASE
						WHEN ( CLM LIKE 'CD%' OR CLM LIKE 'FG%' OR CLM LIKE 'KB%' )
							AND REPLACE(USE_LENGTH,',','.') <= 2 THEN 'MENU'
						ELSE 'TEXT'
						END)
			) AS EDITOR,
			NVL(RENDERER,(CASE
						WHEN ( CLM LIKE 'CD%' OR CLM LIKE 'FG%' OR CLM LIKE 'KB%' )
							AND REPLACE(USE_LENGTH,',','.') <= 2 THEN 'MENU'
						ELSE 'LABEL'
						END)
			) AS RENDERER,
			NVL(DBTYPE,(CASE 
						WHEN CLS_NAME = 'NUMBER'      THEN 'S9'
						WHEN CLS_NAME LIKE 'VARCHAR%' THEN
							CASE WHEN REPLACE(USE_LENGTH,',','.') <= 30  THEN 'X'
							     WHEN REPLACE(USE_LENGTH,',','.') >  30  THEN 'XK'
							END
						END)
			) AS DBTYPE,
			USE_LENGTH,DATA_DEFAULT,UNIQ,SYSTEM_ID
	from GF05 A
	where A.SYSTEM_ID = '{@SYSTEM_ID1}'
	and   A.TBLSYU    = '{@TBLSYU1}'
	and   A.FGJ       = '1'
	order by CLM,TABLE_NAME
</og:query>

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID2}" maxRowCount="{@maxRowCount}" scope="request">
	select '0' WRITABLE, '' TABLE_NAME,CLM,NAME_JA,CLS_NAME,EDITOR,RENDERER,DBTYPE,USE_LENGTH,DATA_DEFAULT,UNIQ,SYSTEM_ID
	from GEA03 A
	where A.SYSTEM_ID = '{@SYSTEM_ID2}'
	and   A.FGJ       = '1'
	ORDER BY A.CLM
</og:query>

<og:tableMerge
	action        = "DIFFERENCE"
	masterScope   = "session"
	masterKeys    = "CLM"
	diffKeys      = "NAME_JA,CLS_NAME,EDITOR,RENDERER,DBTYPE,USE_LENGTH,DATA_DEFAULT"
	modifyClms    = "UNIQ"
	slaveScope    = "request"
	display       = "true"
/>

<og:value key="lblKey" value="C" />

<og:hidden name="SQL">
	UPDATE GEA03 SET
			NAME_JA    = [NAME_JA],
			CLS_NAME   = [CLS_NAME],
			EDITOR     = [EDITOR],
			RENDERER   = [RENDERER],
			DBTYPE     = [DBTYPE],
			USE_LENGTH = [USE_LENGTH],
			DATA_DEFAULT = [DATA_DEFAULT],
			DYUPD      = '{@USER.YMDH}',
			USRUPD     = '{@USER.ID}',
			PGUPD     = '{@GUI.KEY}'
	WHERE SYSTEM_ID = '{@SYSTEM_ID2}'
	AND   CLM       = [CLM]
	AND   KBSAKU != '0'
</og:hidden>

<og:hidden name="SQL2">
	INSERT INTO GEA08
		(SYSTEM_ID,CLM,NAME_JA,LNAME,KBSAKU,KBLBL,LANG,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		('{@SYSTEM_ID2}',[CLM],[NAME_JA],[NAME_JA],'1','1','ja',
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
</og:hidden>
