/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

/**
 * [PN],[OYA] などの [] で指定されたカラムで表されたフォーマットデータに対して、
 * DBTableModel オブジェクトを適用して 各カラムに実データを割り当てるオブジェクトです。
 *
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface DataModel<T> {

	/**
	 * row にあるセルのオブジェクト値を置き換えます。
	 *
	 * @param   vals  新しい配列値。
	 * @param   row   値が変更される行(無視されます)
	 */
	void setValues( final T[] vals,final int row ) ;

	/**
	 * カラム名に対応する カラム番号を返します。
	 *
	 * 特殊なカラムが指定された場合は、負の値を返します。
	 * 例えば、[KEY.カラム名]、[I]、[ROW.ID] など、特定の負の値を返します。
	 * また、カラム名が元のデータモデルに存在しない場合も、負の値か、
	 * Exception を返します。負の値なのか、Exception なのかは、
	 * 実装に依存します。
	 *
	 * @param   columnName  値が参照されるカラム番号
	 * @return  指定されたセルのカラム番号
	 */
	int getColumnNo( final String columnName ) ;

	/**
	 * カラム名配列を返します。
	 * 配列オブジェクトは、clone されたコピーを返します。
	 *
	 * @return   nm String[]
	 */
	String[] getNames();

	/**
	 * row にあるセルの属性値を配列で返します。
	 *
	 * @param   row     値が参照される行
	 * @return  指定されたセルの属性値 T[]
	 *
	 */
	T[] getValues( int row ) ;

	/**
	 * row および clm にあるセルの属性値を返します。
	 *
	 * @param   row     値が参照される行
	 * @param   clm     値が参照される列
	 * @return  指定されたセルの値 T
	 *
	 */
	T getValue(int row, int clm) ;
	
	/**
	 * clm のNativeタイプを返します。
	 * Nativeタイプはorg.opengion.fukurou.model.NativeTypeで定義されています。
	 * 
	 * @og.rev 4.1.1.2 (2008/02/28) 新規追加
	 * 
	 * @param  clm      値が参照される列
	 * @return Nativeタイプ
	 * @see org.opengion.fukurou.model.NativeType
	 */
	NativeType getNativeType( int clm );
}
