/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.report;

import java.util.Map;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * RFID発行処理のためのBPELサービスを起動するためのインターフェースです。
 *
 * @og.group 帳票システム
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public interface RFIDPrintPointService {

	/**
	 * 帳票起動された要求番号をセットします。
	 *
	 * @param   ykno 要求NO
	 */
	void setYkno( String ykno ) ;

	/**
	 * システムIDをセットします。
	 *
	 * @param   systemId システムID
	 */
	void setSystemId( String systemId ) ;

	/**
	 * 実行方法をセットします。
	 *
	 * @param   fgrun 実行方法
	 */
	void setFgrun( String fgrun ) ;

	/**
	 * 帳票デーモンが実行されているホスト名をセットします。
	 *
	 * @param   hostName ホスト名
	 */
	void setHostName( String hostName ) ;

	/**
	 * プリンター名をセットします。
	 *
	 * @param   printerName プリンタ名
	 */
	void setPrinterName( String printerName ) ;

	/**
	 * DBTableModel をセットします。
	 *
	 * @param   table DBTableModel
	 */
	void setTable( DBTableModel table ) ;

	/**
	 * RFIDのレイアウトデータをセットします。
	 * キーはカラム名です。
	 * 値はGE58で定義された出力区分及びパラメーターの配列です。
	 * 配列の各インデックス番号の意味は、RFIDPrintRequestを参照して下さい。
	 *
	 * @param   layout RFIDレイアウト
	 */
	void setLayout( Map<String, String[]> layout ) ;

	/**
	 * REPORT_RFID_SERVICE_CLASSから起動するプログラムのディレクトリをセットします。
	 *
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param dir
	 */
	void setPrgDir( String dir );

	/**
	 * REPORT_RFID_SERVICE_CLASSから起動するプログラムをセットします。
	 * 
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param file 
	 */
	void setPrgFile( String file );
	
	/**
	 * ファイル出力時のディレクトリを指定します
	 * 
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @param dir 
	 */
	void setOutDir( String dir );
	
	/**
	 * 現在の印刷状況を返します
	 * 
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @return 完成フラグ
	 */
	String getFgkan();
	
	/**
	 * エラーメッセージを返します
	 * 
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID対応
	 * @return エラーメッセージ
	 */
	String getErrMsg();

	/**
	 * RFID発行処理を実行します。
	 * 
	 * @og.rev 4.3.3.0 (2008/10/01) 板金RFID voidからbooleanに変更
	 * @return 結果 (正常：true / 異常：false)
	 */
	// void execute() ;
	boolean execute() ;
}
