/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

// import org.opengion.hayabusa.html.TableFormatter;
import org.opengion.hayabusa.html.FormatterType;

/**
 * 検索結果に対してフッターフォーマットを変更するタグです。
 *
 * @og.formSample
 * ●形式：&lt;og:tfoot rowspan="..." &gt; ... Body ... &lt;/og:tfoot&gt;
 * ●body：あり
 *
 * ●使用例
 *      &lt;og:view
 *          viewFormType = &quot;HTMLCustomTable&quot;
 *          command      = &quot;{&#064;command}&quot;
 *          writable     = &quot;false&quot;
 *          startNo      = &quot;{&#064;startNo}&quot;
 *          pageSize     = &quot;{&#064;pageSize}&quot;
 *          rowspan      = &quot;1&quot;
 *          numberType   = &quot;delete&quot;
 *      &gt;
 *        ...
 *          &lt;og:tfoot rowspan=&quot;1&quot; &gt;
 *              &lt;tr&gt;&lt;td&gt;&amp;amp;nbsp;&lt;/td&gt;&lt;td&gt;[VALUENAME]&lt;/td&gt;&lt;td&gt;[DESCRIPTION]&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:tfoot&gt;
 *      &lt;/og:view&gt;
 *
 * @og.rev 3.5.4.0 (2003/11/25) TFormatTag のサブクラスとして再定義。
 * @og.group 画面部品
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class TfootTag extends TFormatTag {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	private static final long serialVersionUID = 4000 ;	// 4.0.0 (2005/01/31)

	/**
	 * このフォーマットのタイプを返します。
	 *
	 * @og.tag
	 * タイプは、"head/body/foot" の中から、指定します。
	 *
	 * @og.rev 3.5.4.0 (2003/11/25) 新規追加
	 *
	 * @return	このフォーマットのタイプを返します。
	 */
	protected FormatterType getType() {
		return FormatterType.TYPE_FOOT;
	}

//	protected String getType() {
//		return TableFormatter.TYPE_FOOT;
//	}
}
