/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;

public final class SystemParameter {
    private final String original;
    private final String[] clms;
    private final String[] formats;

    public SystemParameter(String string) {
        this.original = string;
        if (string == null || string.length() == 0 || string.indexOf("{@") < 0) {
            this.clms = null;
            this.formats = null;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.JAPAN);
            String string2 = simpleDateFormat.format(new Date());
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.original, "{}");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.charAt(0) == '@') {
                    String string4 = string3.substring(1);
                    if (string4.startsWith("SYS.YMD")) {
                        arrayList2.add(string2.substring(0, 8));
                        continue;
                    }
                    if (string4.startsWith("SYS.YMDH")) {
                        arrayList2.add(string2);
                        continue;
                    }
                    if (string4.startsWith("SYS.HMS")) {
                        arrayList2.add(string2.substring(8));
                        continue;
                    }
                    arrayList2.add(string4);
                    continue;
                }
                arrayList.add(string3);
            }
            this.clms = arrayList2.toArray(new String[0]);
            this.formats = arrayList.toArray(new String[0]);
        }
    }

    public String replace(HybsEntry[] hybsEntryArray) {
        if (this.formats == null || this.clms == null) {
            return this.original;
        }
        if (hybsEntryArray == null || hybsEntryArray.length == 0) {
            return this.original;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (hybsEntryArray != null) {
            int n = hybsEntryArray.length;
            for (int i = 0; i < n; ++i) {
                hashMap.put(hybsEntryArray[i].getKey(), hybsEntryArray[i].getValue());
            }
        }
        return this.replace(hashMap);
    }

    public String replace(Map<String, String> map) {
        if (this.formats == null || this.clms == null) {
            return this.original;
        }
        if (map == null || map.size() == 0) {
            return this.original;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.formats.length; ++i) {
            stringBuilder.append(this.formats[i]);
            if (i >= this.clms.length) continue;
            stringBuilder.append(StringUtil.nval(map.get(this.clms[i]), ""));
        }
        return stringBuilder.toString();
    }
}

