/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.text.MessageFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.LabelInterface;

public final class LabelData
implements LabelInterface {
    public static final int CLM = 0;
    public static final int SNAME = 1;
    public static final int LNAME = 2;
    public static final int DESCRIPTION = 3;
    public static final int DATA_SIZE = 4;
    public static final int FG_LOAD = 4;
    private final String key;
    private final String label;
    private final String shortLabel;
    private final String longLabel;
    private final String description;
    private final boolean official;
    private final boolean isFormat;
    private final String rawShortLabel;
    private final boolean isFormatDesc;

    LabelData(String string) {
        this.label = this.key = string.intern();
        this.shortLabel = this.key;
        this.longLabel = this.key;
        this.description = "";
        this.official = false;
        this.isFormat = false;
        this.rawShortLabel = this.key;
        this.isFormatDesc = false;
    }

    LabelData(String[] stringArray) {
        this.key = stringArray[0].intern();
        this.label = StringUtil.nval2((String)stringArray[2], (String)"");
        this.description = stringArray[3];
        this.official = true;
        this.isFormat = this.label.indexOf(123) >= 0;
        this.isFormatDesc = this.description.indexOf(123) >= 0;
        this.longLabel = this.description == null || this.description.length() == 0 ? this.label : "<span title=\"" + StringUtil.htmlFilter((String)this.description) + "\">" + this.label + "</span>";
        String string = stringArray[1];
        if (string == null || string.length() == 0) {
            this.shortLabel = this.longLabel;
            this.rawShortLabel = this.longLabel;
        } else {
            String string2 = this.description == null || this.description.length() == 0 ? this.label : this.description;
            this.shortLabel = "<span title=\"" + StringUtil.htmlFilter((String)string2) + "\">" + string + "</span>";
            this.rawShortLabel = string;
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public String getLongLabel() {
        return this.longLabel;
    }

    @Override
    public String getLongLabel(String string) {
        String string2 = string == null ? this.longLabel : "<span title=\"" + StringUtil.htmlFilter((String)string) + "\">" + this.label + "</span>";
        return string2;
    }

    @Override
    public String getMessage(String[] stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[]{} : stringArray;
        if (this.isFormat) {
            string = MessageFormat.format(this.label, stringArray2);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.label);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null || stringArray2[i].equals(this.label)) continue;
                stringBuilder.append(" ").append(stringArray2[i]);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescription(String[] stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[]{} : stringArray;
        if (this.isFormatDesc) {
            string = MessageFormat.format(this.description, stringArray2);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.description);
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public boolean isOfficial() {
        return this.official;
    }

    public String getRawShortLabel() {
        return this.rawShortLabel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("CLM :").append(this.key);
        stringBuilder.append(" SNAME :").append(this.shortLabel);
        stringBuilder.append(" LNAME :").append(this.longLabel);
        stringBuilder.append(" DESCRIPTION :").append(this.description).append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

