/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.URLConnect;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.xml.XSLT;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class URLConnectTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String DEFAULT_USER = "SYSTEM:MANAGER";
    private String urlStr = null;
    private String[] keys = null;
    private String[] vals = null;
    private String xslFile = null;
    private String saveFile = null;
    private String postKey = null;
    private String postData = null;
    private boolean useSystemUser = true;
    private String authUserPass = null;
    private boolean display = false;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String method = "GET";
    private boolean errNglctFlag = false;

    @Override
    public int doStartTag() {
        if (this.postKey == null || this.postData != null) {
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.postData = this.getBodyString();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        block18: {
            this.debugPrint();
            if (this.useSystemUser) {
                this.authUserPass = DEFAULT_USER;
            }
            URLConnect uRLConnect = null;
            try {
                Object object;
                String string = XHTMLTag.urlEncode((String[])this.keys, (String[])this.vals);
                if (this.postKey != null) {
                    this.method = "POST";
                    object = this.postKey + "=" + this.postData;
                    string = string + "&" + (String)object;
                }
                if (!"POST".equals(this.method)) {
                    this.urlStr = XHTMLTag.addUrlEncode((String)this.urlStr, (String)string);
                }
                uRLConnect = new URLConnect(this.urlStr, this.authUserPass);
                if (this.proxyHost != null) {
                    uRLConnect.setProxy(this.proxyHost, this.proxyPort);
                }
                if ("POST".equals(this.method) && this.keys != null && this.vals != null) {
                    uRLConnect.setPostData(string);
                }
                uRLConnect.connect();
                object = null;
                if (this.display) {
                    object = FileUtil.getNonFlushPrintWriter((Writer)this.pageContext.getOut());
                } else if (this.saveFile != null) {
                    object = FileUtil.getPrintWriter((File)new File(this.saveFile), (String)"UTF-8");
                }
                if (object != null) {
                    if (this.xslFile != null) {
                        XSLT xSLT = new XSLT();
                        xSLT.setXslFile(this.xslFile);
                        xSLT.setOutFile((Writer)object);
                        xSLT.transform((Reader)uRLConnect.getReader());
                        xSLT.close();
                    } else {
                        ((Writer)object).write(uRLConnect.readData());
                    }
                    Closer.ioClose((Closeable)object);
                }
            }
            catch (IOException iOException) {
                String string = "\u30c7\u30fc\u30bf\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " url=[" + this.urlStr + "]";
                if (this.errNglctFlag) {
                    LogWriter.log((String)string);
                    break block18;
                }
                throw new HybsSystemException(string, iOException);
            }
            finally {
                if (uRLConnect != null) {
                    uRLConnect.disconnect();
                }
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.urlStr = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.keys = null;
        this.vals = null;
        this.xslFile = null;
        this.saveFile = null;
        this.postKey = null;
        this.postData = null;
        this.useSystemUser = true;
        this.authUserPass = null;
        this.display = false;
        this.method = "GET";
        this.errNglctFlag = false;
    }

    public void setUrl(String string) {
        this.urlStr = StringUtil.nval((String)this.getRequestParameter(string), (String)this.urlStr);
    }

    public void setProxyHost(String string) {
        this.proxyHost = StringUtil.nval((String)this.getRequestParameter(string), (String)this.proxyHost);
        this.useSystemUser = false;
    }

    public void setProxyPort(String string) {
        this.proxyPort = StringUtil.nval((String)this.getRequestParameter(string), (int)this.proxyPort);
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setMethod(String string) {
        this.method = StringUtil.nval((String)this.getRequestParameter(string), (String)this.method);
    }

    public void setUseSystemUser(String string) {
        this.useSystemUser = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSystemUser);
    }

    public void setAuthUserPass(String string) {
        this.authUserPass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authUserPass);
    }

    public void setXslFile(String string) {
        this.xslFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.xslFile));
    }

    public void setDisplay(String string) {
        this.display = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.display);
        if (this.display && this.saveFile != null) {
            String string2 = "display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setSaveFile(String string) {
        this.saveFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.saveFile));
        if (this.display) {
            String string2 = "display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setPostKey(String string) {
        this.postKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.postKey);
    }

    public void setPostFile(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            FileString fileString = new FileString();
            fileString.setFilename(HybsSystem.url2dir(string2));
            this.postData = fileString.getValue();
        }
    }

    public void setErrNeglect(String string) {
        this.errNglctFlag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.errNglctFlag);
    }

    @Override
    protected String getTagName() {
        return "urlConnect";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("urlStr", (Object)this.urlStr).println("useSystemUser", (Object)this.useSystemUser).println("authUserPass", (Object)this.authUserPass).println("display", (Object)this.display).println("xslFile", (Object)this.xslFile).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

