/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionPool;
import org.opengion.fukurou.db.DatabaseConfig;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.AbstractObjectPool;
import org.opengion.fukurou.util.ApplicationInfo;

public final class ConnectionFactory {
    private static final Map<String, ConnectionPool> map = new HashMap<String, ConnectionPool>();
    private static String DBID = "DEFAULT";
    private static ConnectionPool DEF_POOL;
    private static final String CR;
    private static final int BUFFER_MIDDLE = 200;
    private static DatabaseConfig dbc;

    private ConnectionFactory() {
    }

    public static void init(String string, String string2) {
        dbc = string2 == null || string2.length() == 0 ? new DatabaseConfig() : new DatabaseConfig(string2);
        EDbid eDbid = dbc.getDbid(DBID = string == null || string.length() == 0 || dbc.getDbid(string) == null ? "DEFAULT" : string);
        if (eDbid == null) {
            String string3 = "\u521d\u671f\u5316\u6642\u306b\u3001\u6307\u5b9a\u306eDBID\u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[Key =" + DBID + "]";
            throw new RuntimeException(string3);
        }
        DEF_POOL = new ConnectionPool(eDbid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connection(String string, ApplicationInfo applicationInfo) {
        Object object;
        ConnectionPool connectionPool;
        if (string == null || string.length() == 0 || DBID.equalsIgnoreCase(string)) {
            connectionPool = DEF_POOL;
        } else {
            object = string.toUpperCase(Locale.JAPAN);
            Map<String, ConnectionPool> map = ConnectionFactory.map;
            synchronized (map) {
                connectionPool = ConnectionFactory.map.get(object);
                if (connectionPool == null) {
                    EDbid eDbid = dbc.getDbid((String)object);
                    if (eDbid == null) {
                        String string2 = "\u6307\u5b9a\u306eDBID\u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[Key =" + (String)object + "]";
                        throw new RuntimeException(string2);
                    }
                    connectionPool = new ConnectionPool(eDbid);
                    ConnectionFactory.map.put((String)object, connectionPool);
                }
            }
        }
        object = (Connection)connectionPool.newInstance();
        if (applicationInfo != null && connectionPool.useApplicationInfo()) {
            applicationInfo.callAppInfo((Connection)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, String string) {
        if (connection != null) {
            if (string == null || string.length() == 0 || DBID.equalsIgnoreCase(string)) {
                DEF_POOL.release(connection);
            } else {
                String string2 = string.toUpperCase(Locale.JAPAN);
                Map<String, ConnectionPool> map = ConnectionFactory.map;
                synchronized (map) {
                    ConnectionPool connectionPool = ConnectionFactory.map.get(string2);
                    if (connectionPool != null) {
                        connectionPool.release(connection);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection connection, String string) {
        if (connection != null) {
            if (string == null || string.length() == 0 || DBID.equalsIgnoreCase(string)) {
                DEF_POOL.remove(connection);
            } else {
                String string2 = string.toUpperCase(Locale.JAPAN);
                Map<String, ConnectionPool> map = ConnectionFactory.map;
                synchronized (map) {
                    ConnectionPool connectionPool = ConnectionFactory.map.get(string2);
                    if (connectionPool != null) {
                        connectionPool.remove(connection);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void realClose() {
        ConnectionPool[] connectionPoolArray = DEF_POOL;
        synchronized (DEF_POOL) {
            if (!DEF_POOL.isEmpty()) {
                DEF_POOL.clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Object object = map;
            synchronized (object) {
                if (map.isEmpty()) {
                    return;
                }
                connectionPoolArray = map.values().toArray(new ConnectionPool[map.size()]);
                map.clear();
            }
            for (int i = 0; i < connectionPoolArray.length; ++i) {
                object = connectionPoolArray[i];
                if (object == null || ((AbstractObjectPool)object).isEmpty()) continue;
                ((AbstractObjectPool)object).clear();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String information() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("Connection Information :").append(CR);
        int n = 0;
        ConnectionPool[] connectionPoolArray = DEF_POOL;
        synchronized (DEF_POOL) {
            if (!DEF_POOL.isEmpty()) {
                n += DEF_POOL.size();
                stringBuilder.append(DEF_POOL.toString());
                stringBuilder.append("<br /><hr />");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            connectionPoolArray = null;
            Map<String, ConnectionPool> map = ConnectionFactory.map;
            synchronized (map) {
                if (!ConnectionFactory.map.isEmpty()) {
                    connectionPoolArray = ConnectionFactory.map.values().toArray(new ConnectionPool[ConnectionFactory.map.size()]);
                }
            }
            if (connectionPoolArray != null) {
                for (int i = 0; i < connectionPoolArray.length; ++i) {
                    ConnectionPool connectionPool = connectionPoolArray[i];
                    if (connectionPool == null || connectionPool.isEmpty()) continue;
                    n += connectionPool.size();
                    stringBuilder.append(connectionPool.toString());
                    stringBuilder.append("<br /><hr />");
                }
            }
            stringBuilder.append(CR);
            return stringBuilder.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBFullName(String string) {
        String string2 = null;
        if (string == null || string.length() == 0 || DBID.equalsIgnoreCase(string)) {
            string2 = DEF_POOL.getDBName() + " " + DEF_POOL.getDBVersion();
        } else {
            String string3 = string.toUpperCase(Locale.JAPAN);
            ConnectionPool connectionPool = null;
            Map<String, ConnectionPool> map = ConnectionFactory.map;
            synchronized (map) {
                connectionPool = ConnectionFactory.map.get(string3);
                if (connectionPool == null) {
                    ConnectionFactory.close(ConnectionFactory.connection(string, null), string);
                }
            }
            if (connectionPool != null) {
                string2 = connectionPool.getDBName() + " " + connectionPool.getDBVersion();
            }
        }
        return string2;
    }

    static {
        CR = System.getProperty("line.separator");
    }
}

