/**************************************************************************/
/* GEA09 ( ユーザーアクセス画面管理テーブル )                             */
/*                                                                        */
/* Created : 2010/05/07 16:07:31                                          */
/**************************************************************************/
CREATE TABLE GEA09 (
   SYSTEM_ID   VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , USERID      VARCHAR2(10)                 NOT NULL      /* 20  ユーザーID       */
 , GUIKEY      VARCHAR2(30)                 NOT NULL      /* 30  画面ID           */
 , SEQNO       NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  表示順           */
 , NAME_JA     VARCHAR2(200)                              /* 50  名称             */
 , LAST_ACCESS VARCHAR2(14)                               /* 60  最終アクセス時間 */
 , FGFAVORITE  VARCHAR2(1)                                /* 70  お気に入り       */
 , CLASSIFY    VARCHAR2(120)                              /* 80  分類             */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー     */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ       */
 , DYSET       VARCHAR2(14)                               /* 820 登録日時         */
 , PGSET       VARCHAR2(10)                               /* 830 作成PG           */
 , PGPSET      VARCHAR2(10)                               /* 840 作成親PG         */
 , USRSET      VARCHAR2(10)                               /* 850 作成社員         */
 , DYUPD       VARCHAR2(14)                               /* 860 更新日時         */
 , PGUPD       VARCHAR2(10)                               /* 870 更新PG           */
 , PGPUPD      VARCHAR2(10)                               /* 880 更新親PG         */
 , USRUPD      VARCHAR2(10)                               /* 890 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA09S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA09T01 
BEFORE INSERT ON GEA09
FOR EACH ROW 
BEGIN 
SELECT GEA09S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

