<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0002"
	title    = "画面"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="CLM" action="TBLSET" value="[GUIKEY]" />
	<og:columnSet command="{@command}" columnId="EXIST_GEA08" action="SET" value="0" />
</og:entry>

<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
	select '1' EXIST_GEA08, A.UNIQ UNIQ_GEA08
	from GEA08 A
	where A.SYSTEM_ID in ( '{@MEM.SYSTEM_ID}','**' )
	and A.CLM = [CLM]
	and A.LANG = [LANG]
	and A.FGJ in ('0','1')
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:tableFilter>
<og:equals val1="COPY|MODIFY|INSERT" val2="{@sqlType}" contains="true">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "0"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "INSERT"
			table		= "GEA08"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,SYSTEM_ID,LANG,RELEASE_NOTES,CDKH,RDC_CODE"
			constKeys	= "KBLBL,FGLOAD"
			constVals	= "3,1"
		/>
	</og:tableUpdate>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "1"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "UPDATE"
			table		= "GEA08"
			where		= "UNIQ = [UNIQ_GEA08]"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,SYSTEM_ID,LANG,RELEASE_NOTES,CDKH,RDC_CODE"
			constKeys	= "KBLBL,FGLOAD"
			constVals	= "3,1"
		/>
	</og:tableUpdate>
</og:equals>
<og:equals val1="DELETE" val2="{@sqlType}">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA08"
			where			= "UNIQ = [UNIQ_GEA08]"
			names			= "CDKH"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:equals>

<og:tableUpdate
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA11"
		where			= "UNIQ = [UNIQ]"
		names			= "GUIKEY,ADDRESS,SEQNO,GUILVL,NAME_JA,LABEL_CLM,GROUPS,ROLES,RWMODE,KBLINK,TARGET,PARAM,SYSTEM_ID,KBSAKU,COMMENTS,RELEASE_NOTES,CDKH,RDC_CODE"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<!-- SEQNOの再セット -->
<og:query
	dbid 		= "{@MEM.TO_DBID}"
	command		= "NEW" >
	<jsp:text>
		SELECT SEQNO,GUILVL,UNIQ
		FROM   GEA11
		WHERE  SYSTEM_ID =  '{@MEM.SYSTEM_ID}'
		AND    FGJ       IN ( '0','1' )
		ORDER  BY SEQNO
	</jsp:text>
</og:query>
<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,BREAK_CLM" vals="SEQNO,GUILVL" selectedAll="true" />
<og:tableUpdate
	dbid 		= "{@MEM.TO_DBID}"
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate" >
	<jsp:text>
		UPDATE GEA11 SET
			SEQNO  = [SEQNO]
		WHERE UNIQ = [UNIQ]
		AND SEQNO != [SEQNO]
	</jsp:text>
</og:tableUpdate>

<!-- リソースキャッシュのクリア -->
<og:engine guiClear="true" />

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="GUI"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
