<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP04"
	title    = "振分条件マスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck
	command = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
			JOKEN,PRTID,FGRUN,DMN_GRP,PRGDIR,PRGFILE,COMMENTS,SYSTEM_ID,LANG,DMN_TIME,OUT_DIR,OUT_FILE,
			RDC_CODE,RELEASE_NOTES,FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD
		from GE53
	</jsp:text>

	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"		/>
		<og:and value = "JOKEN     LIKE '{@JOKEN}%'"		/>
		<og:and value = "FGJ       in   ('0','1')"		/>
		<og:and value = "FGRUN     =    '{@FGRUN}'"		/>
		<og:and value = "PRTID     LIKE '{@PRTID}%'"		/>
		<og:and value = "DMN_GRP   LIKE '{@DMN_GRP}%'"	/>
		<og:and value = "LANG      =    '{@LANG}'"		/>
		<og:and value = "RDC_CODE   = '{@RDC_CODE}'"		/>
		<og:and value = "DYUPD  &gt;= '{@DYUPDFROM}'"	/>
		<og:and value = "DYUPD  &lt;= '{@DYUPDTO}99'"	/>
		<og:and value = "RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value = "{@SORT}" defaultVal="SYSTEM_ID,JOKEN"  />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="JOKEN"     must="true" />
<og:columnEditor column="FGRUN"     must="true" />
<og:columnEditor column="DMN_GRP"   must="true" />
<og:columnEditor column="PRGDIR"    must="true" />
<og:columnEditor column="PRGFILE"   must="true" />

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="PRTID" editor="DBMENU" addNoValue="true" >
<jsp:text>
	select PRTID,PRTID
	from GE55
	where FGJ in ('0','1')
	and PRT_GRP is null
	<og:where startKey="and">
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
	</og:where>
	group by PRTID,PRTID
	union
	select PRT_GRP,PRT_GRP
	from GE55
	where FGJ in ('0','1')
	and PRT_GRP is not null
	<og:where startKey="and">
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
	</og:where>
	group by PRT_GRP,PRT_GRP
	order by 1
</jsp:text>
</og:columnEditor>

<og:viewLink command="{@command}">
	<og:link column="PRTID" gamenId="REP06" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,PRTID" vals="NEW,[SYSTEM_ID],[PRTID]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />

	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
