/**************************************************************************/
/* GF73 ( 使用カラム状態テーブル )                                        */
/*                                                                        */
/* Created : 2010/05/07 16:07:45                                          */
/**************************************************************************/
CREATE TABLE GF73 (
   SYSTEM_ID   VARCHAR(10)                  NOT NULL                  /* 10  システムID     */
 , ADDRESS     VARCHAR(256)                                           /* 20  アドレス       */
 , PRE_FIX     VARCHAR(10)                  NOT NULL                  /* 29  名前空間       */
 , FILENAME    VARCHAR(30)                                            /* 30  ファイル名     */
 , FILEPATH    VARCHAR(256)                                           /* 40  ファイルパス   */
 , MODIFIED    VARCHAR(14)                                            /* 50  最終更新日     */
 , TAGNAME     VARCHAR(30)                                            /* 60  タグ名称       */
 , FORM_TYPE   VARCHAR(10)                                            /* 70  フォームタイプ */
 , FORM_NAME   VARCHAR(200)                                           /* 80  名称           */
 , FORM_VAL    VARCHAR(1000)                                          /* 90  値             */
 , DEFAULT_VAL VARCHAR(100)                                           /* 100 デフォルト値   */
 , LBLCD       VARCHAR(30)                                            /* 110 ラベルコード   */
 , MSGCD       VARCHAR(20)                                            /* 120 メッセージID   */
 , MUST        VARCHAR(10)                                            /* 130 必須           */
 , VIEW_LENGTH VARCHAR(10)                                            /* 140 表示桁数       */
 , USE_LENGTH  VARCHAR(9)       DEFAULT '0' NOT NULL                  /* 150 使用桁数       */
 , CODE_CLM    VARCHAR(30)                                            /* 160 コードカラム   */
 , READONLY    VARCHAR(10)                                            /* 170 読取専用       */
 , DISABLED    VARCHAR(10)                                            /* 180 無効           */
 , ROLES       VARCHAR(500)                                           /* 190 ロールズ       */
 , TEXT_DATA   BLOB                                                   /* 200 テキスト       */
 , FGOMIT      VARCHAR(1)       DEFAULT '0' NOT NULL                  /* 210 除外フラグ     */
 , UNIQ        BIGINT                       NOT NULL PRIMARY KEY      /* 800 ユニークキー   */
 , FGJ         VARCHAR(1)       DEFAULT '1' NOT NULL                  /* 810 状態フラグ     */
 , DYSET       VARCHAR(14)                                            /* 820 登録日時       */
 , PGSET       VARCHAR(10)                                            /* 830 作成PG         */
 , PGPSET      VARCHAR(10)                                            /* 840 作成親PG       */
 , USRSET      VARCHAR(10)                                            /* 850 作成社員       */
 , DYUPD       VARCHAR(14)                                            /* 860 更新日時       */
 , PGUPD       VARCHAR(10)                                            /* 870 更新PG         */
 , PGPUPD      VARCHAR(10)                                            /* 880 更新親PG       */
 , USRUPD      VARCHAR(10)                                            /* 890 更新者         */
);

CREATE SEQUENCE GF73S01 ;


CREATE TRIGGER GF73T01 FOR GF73
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF73S01,1 );
  END; 


