/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.taglet;

import com.sun.tools.doclets.Taglet;

/**
 * ソースコメントから、Javadoc を作成する場合のカスタムタグ情報を作成する
 * Taglet インターフェースのAbstract 実装クラスを作成します。
 * デフォルトの タグレットとしての初期値を設定します。
 * つまり、isInlineTag() のみ false を返すメソッドを定義してあります。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public abstract class AbstractTaglet implements Taglet {

	/**
	 * このタグレットがフィールドドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return フィールドドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inField() {
		return true;
	}

	/**
	 * このタグレットがコンストラクタドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return コンストラクタドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inConstructor() {
		return true;
	}

	/**
	 * このタグレットがメソッドドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return メソッドドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inMethod() {
		return true;
	}

	/**
	 * このタグレットが概要ドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return 概要ドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inOverview() {
		return true;
	}

	/**
	 * このタグレットがパッケージドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return パッケージドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inPackage() {
		return true;
	}

	/**
	 * このタグレットがタイプドキュメンテーションで
	 * 使用されている場合、true を返します。
	 * インラインタグについては false が設定されます。
	 *
	 * @return タイプドキュメンテーションの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean inType() {
		return true;
	}

	/**
	 * このタグレットがインラインタグで
	 * 使用されている場合、true を返します。
	 * そうでない場合については false が設定されます。
	 *
	 * @return インラインタグの場合は true、
	 * そうでない場合は false を返します
	 */
	public boolean isInlineTag() {
		return false;
	}
}
