/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.fukurou.util.StringUtil;

import java.io.PrintWriter;

/**
 * 加工なしダブルクォート区切り文字指定データの書き出しクラスです。
 *
 * DefaultTableWriter を継承して，データの出力部のみオーバーライドして，
 * データそのものを加工なしで、ダブルコーテーションで処理して出力します。
 * 本来は、DefaultTableWriter の出力形態のはずですが、過去の互換性との関係で、
 * なまデータを出力するクラスを、追加作成しました。
 * 従来の CSV2 は、このクラスを使用してください。
 *
 * @og.rev 3.7.0.3 (2005/03/01) 新規作成
 * @og.group ファイル出力
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class TableWriter_Data2 extends TableWriter_Default {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	/**
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 *
	 * @og.rev 3.7.0.3 (2005/03/01) 新規作成
	 * @og.rev 3.8.0.1 (2005/06/17) DBTypeが NVAR の場合は、元のUnicodeに戻します。
	 * @og.rev 5.1.6.0 (2010/05/01) DbType の初期値(dbType)を利用する。
	 *
	 * @param	table DBTableModel
	 * @param	writer PrintWriter
	 */
	protected void writeData( final DBTableModel table,final PrintWriter writer ) {
		int numberOfRows = table.getRowCount();
		String separator = getSeparator();
		boolean useNumber = isUseNumber();

		for( int row=0; row<numberOfRows; row++ ) {
			if( useNumber ) {
				writer.print( quotation( String.valueOf( row+1 ) ) );
				writer.print( separator );
			}

			for( int i=0; i<numberOfColumns; i++ ) {
				if( i != 0 ) { writer.print( separator ); }
				int clm = clmNo[i];
				String val = table.getValue(row,clm);
//				if( "NVAR".equals( dbColumn[clm].getDbType()) ) {
				if( dbType[i] == NVAR ) {
					val = StringUtil.getReplaceEscape( val );
				}

				writer.print( quotation( val ) );
			}
			writer.println();
		}
	}
}
